/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestHDFSFileSystemContract;
import org.apache.hadoop.hdfs.ViewDistributedFileSystem;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewDistributedFileSystemContract
extends TestHDFSFileSystemContract {
    private static MiniDFSCluster cluster;
    private static String defaultWorkingDirectory;
    private static Configuration conf;

    @BeforeClass
    public static void init() throws IOException {
        File basedir = GenericTestUtils.getRandomizedTestDir();
        conf.set("fs.permissions.umask-mode", "062");
        cluster = new MiniDFSCluster.Builder(conf, basedir).numDataNodes(2).build();
        defaultWorkingDirectory = "/user/" + UserGroupInformation.getCurrentUser().getShortUserName();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        conf.set("fs.hdfs.impl", ViewDistributedFileSystem.class.getName());
        URI defaultFSURI = URI.create(conf.get("fs.defaultFS"));
        ConfigUtil.addLink((Configuration)conf, (String)defaultFSURI.getHost(), (String)"/user", (URI)defaultFSURI);
        ConfigUtil.addLinkFallback((Configuration)conf, (String)defaultFSURI.getHost(), (URI)defaultFSURI);
        this.fs = FileSystem.get((Configuration)conf);
    }

    @AfterClass
    public static void tearDownAfter() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Override
    protected String getDefaultWorkingDirectory() {
        return defaultWorkingDirectory;
    }

    @Test
    public void testRenameRootDirForbidden() throws Exception {
        LambdaTestUtils.intercept(AccessControlException.class, (String)"InternalDir of ViewFileSystem is readonly", () -> super.testRenameRootDirForbidden());
    }

    static {
        conf = new HdfsConfiguration();
    }
}

