/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.util.Shell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.Test;

public class TestDataDirs {
    @Test(timeout=30000L)
    public void testDataDirParsing() throws Throwable {
        Configuration conf = new Configuration();
        File dir0 = new File("/dir0");
        File dir1 = new File("/dir1");
        File dir2 = new File("/dir2");
        File dir3 = new File("/dir3");
        File dir4 = new File("/dir4");
        File dir5 = new File("/dir5");
        File dir6 = new File("/dir6");
        File dir7 = new File("/dir7");
        String locations1 = "[disk]/dir0,[DISK]/dir1,[sSd]/dir2,[disK]/dir3,[ram_disk]/dir4,[disk]/dir5, [disk] /dir6, [disk] , [nvdimm]/dir7";
        conf.set("dfs.datanode.data.dir", locations1);
        List locations = DataNode.getStorageLocations((Configuration)conf);
        Assert.assertThat((Object)locations.size(), (Matcher)CoreMatchers.is((Object)9));
        Assert.assertThat((Object)((StorageLocation)locations.get(0)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(0)).getUri(), (Matcher)CoreMatchers.is((Object)dir0.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(1)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(1)).getUri(), (Matcher)CoreMatchers.is((Object)dir1.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(2)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.SSD));
        Assert.assertThat((Object)((StorageLocation)locations.get(2)).getUri(), (Matcher)CoreMatchers.is((Object)dir2.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(3)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(3)).getUri(), (Matcher)CoreMatchers.is((Object)dir3.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(4)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.RAM_DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(4)).getUri(), (Matcher)CoreMatchers.is((Object)dir4.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(5)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(5)).getUri(), (Matcher)CoreMatchers.is((Object)dir5.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(6)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(6)).getUri(), (Matcher)CoreMatchers.is((Object)dir6.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(7)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(8)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.NVDIMM));
        Assert.assertThat((Object)((StorageLocation)locations.get(8)).getUri(), (Matcher)CoreMatchers.is((Object)dir7.toURI()));
        String locations2 = "[BadMediaType]/dir0,[ssd]/dir1,[disk]/dir2";
        conf.set("dfs.datanode.data.dir", locations2);
        try {
            locations = DataNode.getStorageLocations((Configuration)conf);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            DataNode.LOG.info("The exception is expected.", (Throwable)iae);
        }
        String locations3 = "/dir0,/dir1";
        conf.set("dfs.datanode.data.dir", locations3);
        locations = DataNode.getStorageLocations((Configuration)conf);
        Assert.assertThat((Object)locations.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((StorageLocation)locations.get(0)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(0)).getUri(), (Matcher)CoreMatchers.is((Object)dir0.toURI()));
        Assert.assertThat((Object)((StorageLocation)locations.get(1)).getStorageType(), (Matcher)CoreMatchers.is((Object)StorageType.DISK));
        Assert.assertThat((Object)((StorageLocation)locations.get(1)).getUri(), (Matcher)CoreMatchers.is((Object)dir1.toURI()));
    }

    @Test
    public void testDataDirFileSystem() throws Exception {
        if (Shell.MAC) {
            throw new AssumptionViolatedException("Not supported on MAC OS");
        }
        Configuration conf = new Configuration();
        String archiveDir = "/home";
        String location = "[DISK]/dir1,[ARCHIVE]" + archiveDir;
        conf.set("dfs.datanode.data.dir", location);
        List locations = DataNode.getStorageLocations((Configuration)conf);
        Assert.assertEquals((long)2L, (long)locations.size());
        conf.set("dfs.datanode.storagetype.ARCHIVE.filesystem", "nothis_filesystem");
        locations = DataNode.getStorageLocations((Configuration)conf);
        Assert.assertEquals((long)1L, (long)locations.size());
        DF df = new DF(new File(archiveDir), conf);
        String fsInfo = df.getFilesystem();
        conf.set("dfs.datanode.storagetype.ARCHIVE.filesystem", fsInfo);
        locations = DataNode.getStorageLocations((Configuration)conf);
        Assert.assertEquals((long)2L, (long)locations.size());
    }

    @Test
    public void testCapacityRatioForDataDir() {
        String config = "[0.9 ]/disk /2, [0.1]/disk2/1";
        Map map = StorageLocation.parseCapacityRatio((String)config);
        Assert.assertEquals((double)0.9, (double)((Double)map.get(new Path("/disk/2").toUri())), (double)0.0);
        Assert.assertEquals((double)0.1, (double)((Double)map.get(new Path("/disk2/1").toUri())), (double)0.0);
        config = "[0.9 ]/disk /2, /disk2/1";
        try {
            StorageLocation.parseCapacityRatio((String)config);
            Assert.fail((String)"Should fail parsing");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Capacity ratio config is not with correct form"));
        }
        config = "[11.1]/disk /2";
        try {
            StorageLocation.parseCapacityRatio((String)config);
            Assert.fail((String)"Should fail parsing");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not between 0 to 1"));
        }
    }
}

