/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodePeerMetrics;
import org.apache.hadoop.hdfs.server.datanode.metrics.OutlierDetector;
import org.apache.hadoop.metrics2.lib.MetricsTestHelper;
import org.apache.hadoop.metrics2.lib.MutableRollingAverages;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestDataNodeOutlierDetectionViaMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(TestDataNodeOutlierDetectionViaMetrics.class);
    @Rule
    public Timeout testTimeout = new Timeout(300000);
    private static final int WINDOW_INTERVAL_SECONDS = 3;
    private static final int ROLLING_AVERAGE_WINDOWS = 10;
    private static final int SLOW_NODE_LATENCY_MS = 20000;
    private static final int FAST_NODE_MAX_LATENCY_MS = 5;
    private static final long MIN_OUTLIER_DETECTION_PEERS = 10L;
    private Random random = new Random(System.currentTimeMillis());
    private Configuration conf;

    @Before
    public void setup() {
        GenericTestUtils.setLogLevel((Logger)DataNodePeerMetrics.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)OutlierDetector.LOG, (Level)Level.TRACE);
        this.conf = new HdfsConfiguration();
    }

    @Test
    public void testOutlierIsDetected() throws Exception {
        String slowNodeName = "SlowNode";
        final DataNodePeerMetrics peerMetrics = new DataNodePeerMetrics("PeerMetrics-For-Test", this.conf);
        MetricsTestHelper.replaceRollingAveragesScheduler((MutableRollingAverages)peerMetrics.getSendPacketDownstreamRollingAverages(), (int)10, (long)3L, (TimeUnit)TimeUnit.SECONDS);
        this.injectFastNodesSamples(peerMetrics);
        this.injectSlowNodeSamples(peerMetrics, "SlowNode");
        peerMetrics.dumpSendPacketDownstreamAvgInfoAsJson();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return peerMetrics.getOutliers().size() > 0;
            }
        }, (long)500L, (long)100000L);
        Map outliers = peerMetrics.getOutliers();
        LOG.info("Got back outlier nodes: {}", (Object)outliers);
        Assert.assertThat((Object)outliers.size(), (Matcher)Is.is((Object)1));
        Assert.assertTrue((boolean)outliers.containsKey("SlowNode"));
    }

    @Test
    public void testWithNoOutliers() throws Exception {
        DataNodePeerMetrics peerMetrics = new DataNodePeerMetrics("PeerMetrics-For-Test", this.conf);
        MetricsTestHelper.replaceRollingAveragesScheduler((MutableRollingAverages)peerMetrics.getSendPacketDownstreamRollingAverages(), (int)10, (long)3L, (TimeUnit)TimeUnit.SECONDS);
        this.injectFastNodesSamples(peerMetrics);
        peerMetrics.dumpSendPacketDownstreamAvgInfoAsJson();
        Assert.assertTrue((boolean)peerMetrics.getOutliers().isEmpty());
    }

    public void injectFastNodesSamples(DataNodePeerMetrics peerMetrics) {
        int nodeIndex = 0;
        while ((long)nodeIndex < 10L) {
            String nodeName = "FastNode-" + nodeIndex;
            LOG.info("Generating stats for node {}", (Object)nodeName);
            int i = 0;
            while ((long)i < 2L * peerMetrics.getMinOutlierDetectionSamples()) {
                peerMetrics.addSendPacketDownstream(nodeName, (long)this.random.nextInt(5));
                ++i;
            }
            ++nodeIndex;
        }
    }

    public void injectSlowNodeSamples(DataNodePeerMetrics peerMetrics, String slowNodeName) throws InterruptedException {
        int i = 0;
        while ((long)i < 2L * peerMetrics.getMinOutlierDetectionSamples()) {
            peerMetrics.addSendPacketDownstream(slowNodeName, 20000L);
            ++i;
        }
    }
}

