/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.web.resources;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestWebHdfsDataLocality {
    static final Logger LOG = LoggerFactory.getLogger(TestWebHdfsDataLocality.class);
    private static final String RACK0 = "/rack0";
    private static final String RACK1 = "/rack1";
    private static final String RACK2 = "/rack2";
    private static final String LOCALHOST = InetAddress.getLoopbackAddress().getHostName();
    @Rule
    public final ExpectedException exception;

    public TestWebHdfsDataLocality() {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
        this.exception = ExpectedException.none();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataLocality() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        String[] racks = new String[]{RACK0, RACK0, RACK1, RACK1, RACK2, RACK2};
        int nDataNodes = racks.length;
        LOG.info("nDataNodes=" + nDataNodes + ", racks=" + Arrays.asList(racks));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(nDataNodes).racks(racks).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            NameNode namenode = cluster.getNameNode();
            DatanodeManager dm = namenode.getNamesystem().getBlockManager().getDatanodeManager();
            LOG.info("dm=" + dm);
            long blocksize = 0x8000000L;
            String f = "/foo";
            for (int i = 0; i < nDataNodes; ++i) {
                DataNode dn = cluster.getDataNodes().get(i);
                String ipAddr = dm.getDatanode(dn.getDatanodeId()).getIpAddr();
                DatanodeInfo chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)PutOpParam.Op.CREATE, (long)-1L, (long)0x8000000L, null, (String)LOCALHOST, null);
                Assert.assertEquals((Object)ipAddr, (Object)chosen.getIpAddr());
            }
            Path p = new Path("/foo");
            FSDataOutputStream out = dfs.create(p, (short)1);
            out.write(1);
            out.close();
            LocatedBlocks locatedblocks = NameNodeAdapter.getBlockLocations(namenode, "/foo", 0L, 1L);
            List lb = locatedblocks.getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)lb.size());
            DatanodeInfoWithStorage[] locations = ((LocatedBlock)lb.get(0)).getLocations();
            Assert.assertEquals((long)1L, (long)locations.length);
            DatanodeInfoWithStorage expected = locations[0];
            HdfsFileStatus status = dfs.getClient().getFileInfo("/foo");
            DatanodeInfo chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)GetOpParam.Op.GETFILECHECKSUM, (long)-1L, (long)0x8000000L, null, (String)LOCALHOST, (HdfsFileStatus)status);
            Assert.assertEquals((Object)expected, (Object)chosen);
            status = dfs.getClient().getFileInfo("/foo");
            chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)GetOpParam.Op.OPEN, (long)0L, (long)0x8000000L, null, (String)LOCALHOST, (HdfsFileStatus)status);
            Assert.assertEquals((Object)expected, (Object)chosen);
            status = dfs.getClient().getFileInfo("/foo");
            chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)PostOpParam.Op.APPEND, (long)-1L, (long)0x8000000L, null, (String)LOCALHOST, (HdfsFileStatus)status);
            Assert.assertEquals((Object)expected, (Object)chosen);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcludeDataNodes() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        String[] racks = new String[]{RACK0, RACK0, RACK1, RACK1, RACK2, RACK2};
        String[] hosts = new String[]{"DataNode1", "DataNode2", "DataNode3", "DataNode4", "DataNode5", "DataNode6"};
        int nDataNodes = hosts.length;
        LOG.info("nDataNodes=" + nDataNodes + ", racks=" + Arrays.asList(racks) + ", hosts=" + Arrays.asList(hosts));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).hosts(hosts).numDataNodes(nDataNodes).racks(racks).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            NameNode namenode = cluster.getNameNode();
            DatanodeManager dm = namenode.getNamesystem().getBlockManager().getDatanodeManager();
            LOG.info("dm=" + dm);
            long blocksize = 0x8000000L;
            String f = "/foo";
            Path p = new Path("/foo");
            FSDataOutputStream out = dfs.create(p, (short)3);
            out.write(1);
            out.close();
            LocatedBlocks locatedblocks = NameNodeAdapter.getBlockLocations(namenode, "/foo", 0L, 1L);
            List lb = locatedblocks.getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)lb.size());
            DatanodeInfoWithStorage[] locations = ((LocatedBlock)lb.get(0)).getLocations();
            Assert.assertEquals((long)3L, (long)locations.length);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 2; ++i) {
                int j;
                sb.append(locations[i].getXferAddr());
                HdfsFileStatus status = dfs.getClient().getFileInfo("/foo");
                DatanodeInfo chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)GetOpParam.Op.GETFILECHECKSUM, (long)-1L, (long)0x8000000L, (String)sb.toString(), (String)LOCALHOST, (HdfsFileStatus)status);
                for (j = 0; j <= i; ++j) {
                    Assert.assertNotEquals((Object)locations[j].getHostName(), (Object)chosen.getHostName());
                }
                status = dfs.getClient().getFileInfo("/foo");
                chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)GetOpParam.Op.OPEN, (long)0L, (long)0x8000000L, (String)sb.toString(), (String)LOCALHOST, (HdfsFileStatus)status);
                for (j = 0; j <= i; ++j) {
                    Assert.assertNotEquals((Object)locations[j].getHostName(), (Object)chosen.getHostName());
                }
                status = dfs.getClient().getFileInfo("/foo");
                chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)PostOpParam.Op.APPEND, (long)-1L, (long)0x8000000L, (String)sb.toString(), (String)LOCALHOST, (HdfsFileStatus)status);
                for (j = 0; j <= i; ++j) {
                    Assert.assertNotEquals((Object)locations[j].getHostName(), (Object)chosen.getHostName());
                }
                sb.append(",");
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcludeWrongDataNode() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        String[] racks = new String[]{RACK0};
        String[] hosts = new String[]{"DataNode1"};
        int nDataNodes = hosts.length;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).hosts(hosts).numDataNodes(nDataNodes).racks(racks).build();
        try {
            cluster.waitActive();
            NameNode namenode = cluster.getNameNode();
            NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/path", (HttpOpParam.Op)PutOpParam.Op.CREATE, (long)0L, (long)0x8000000L, (String)"DataNode2", (String)LOCALHOST, null);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to exclude DataNode2" + e.getMessage()));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testChooseDatanodeBeforeNamesystemInit() throws Exception {
        NameNode nn = (NameNode)Mockito.mock(NameNode.class);
        Mockito.when((Object)nn.getNamesystem()).thenReturn(null);
        this.exception.expect(IOException.class);
        this.exception.expectMessage("Namesystem has not been initialized yet.");
        NamenodeWebHdfsMethods.chooseDatanode((NameNode)nn, (String)"/path", (HttpOpParam.Op)PutOpParam.Op.CREATE, (long)0L, (long)0x8000000L, null, (String)LOCALHOST, null);
    }
}

