/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.fs.viewfs.ViewFsTestSetup;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestViewFileSystemOverloadSchemeWithDFSAdmin {
    private static final String FS_IMPL_PATTERN_KEY = "fs.%s.impl";
    private static final String HDFS_SCHEME = "hdfs";
    private Configuration conf = null;
    private MiniDFSCluster cluster = null;
    private URI defaultFSURI;
    private File localTargetDir;
    private static final String TEST_ROOT_DIR = PathUtils.getTestDirName(TestViewFileSystemOverloadSchemeWithDFSAdmin.class);
    private static final String HDFS_USER_FOLDER = "/HDFSUser";
    private static final String LOCAL_FOLDER = "/local";
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT = System.out;
    private static final PrintStream OLD_ERR = System.err;

    @Before
    public void startCluster() throws IOException {
        this.conf = new Configuration();
        this.conf.setInt("ipc.client.connect.max.retries", 1);
        this.conf.set(String.format(FS_IMPL_PATTERN_KEY, HDFS_SCHEME), ViewFileSystemOverloadScheme.class.getName());
        this.conf.set(String.format("fs.viewfs.overload.scheme.target.%s.impl", HDFS_SCHEME), DistributedFileSystem.class.getName());
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitClusterUp();
        this.defaultFSURI = URI.create(this.conf.get("fs.defaultFS"));
        this.localTargetDir = new File(TEST_ROOT_DIR, "/root/");
        Assert.assertEquals((Object)HDFS_SCHEME, (Object)this.defaultFSURI.getScheme());
    }

    @After
    public void tearDown() throws IOException {
        try {
            System.out.flush();
            System.err.flush();
        }
        finally {
            System.setOut(OLD_OUT);
            System.setErr(OLD_ERR);
        }
        if (this.cluster != null) {
            FileSystem.closeAll();
            this.cluster.shutdown();
        }
        this.resetStream();
    }

    private void redirectStream() {
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    private void resetStream() {
        this.out.reset();
        this.err.reset();
    }

    private static void scanIntoList(ByteArrayOutputStream baos, List<String> list) {
        Scanner scanner = new Scanner(baos.toString());
        while (scanner.hasNextLine()) {
            list.add(scanner.nextLine());
        }
        scanner.close();
    }

    private void assertErrMsg(String errorMsg, int line) {
        ArrayList errList = Lists.newArrayList();
        TestViewFileSystemOverloadSchemeWithDFSAdmin.scanIntoList(this.err, errList);
        Assert.assertThat(errList.get(line), (Matcher)CoreMatchers.containsString((String)errorMsg));
    }

    private void assertOutMsg(String outMsg, int line) {
        ArrayList errList = Lists.newArrayList();
        TestViewFileSystemOverloadSchemeWithDFSAdmin.scanIntoList(this.out, errList);
        Assert.assertThat(errList.get(line), (Matcher)CoreMatchers.containsString((String)outMsg));
    }

    void addMountLinks(String mountTable, String[] sources, String[] targets, Configuration config) throws IOException, URISyntaxException {
        ViewFsTestSetup.addMountLinksToConf((String)mountTable, (String[])sources, (String[])targets, (Configuration)config);
    }

    @Test
    public void testSaveNameSpace() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getHost(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-fs", this.defaultFSURI.toString(), "-safemode", "enter"});
        Assert.assertEquals((long)0L, (long)ret);
        this.redirectStream();
        ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-fs", this.defaultFSURI.toString(), "-saveNamespace"});
        Assert.assertEquals((long)0L, (long)ret);
        this.assertOutMsg("Save namespace successful", 0);
        ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-fs", this.defaultFSURI.toString(), "-safemode", "leave"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    @Test
    public void testSaveNamespaceWithoutSpecifyingFS() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getHost(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-safemode", "enter"});
        Assert.assertEquals((long)0L, (long)ret);
        this.redirectStream();
        ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-saveNamespace"});
        this.assertOutMsg("Save namespace successful", 0);
        Assert.assertEquals((long)0L, (long)ret);
        ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-safemode", "leave"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    @Test
    public void testSafeModeWithWrongFS() throws Exception {
        String wrongFsUri = "hdfs://nonExistent";
        Path hdfsTargetPath = new Path(wrongFsUri + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getHost(), new String[]{HDFS_USER_FOLDER}, new String[]{hdfsTargetPath.toUri().toString()}, this.conf);
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        this.redirectStream();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-fs", wrongFsUri, "-safemode", "enter"});
        Assert.assertEquals((long)-1L, (long)ret);
        this.assertErrMsg("safemode: java.net.UnknownHostException: nonExistent", 0);
    }

    @Test
    public void testSafeModeShouldFailOnLocalTargetFS() throws Exception {
        this.addMountLinks(this.defaultFSURI.getHost(), new String[]{LOCAL_FOLDER}, new String[]{this.localTargetDir.toURI().toString()}, this.conf);
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        String uri = this.defaultFSURI.toString() + LOCAL_FOLDER;
        this.redirectStream();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-fs", uri, "-safemode", "enter"});
        Assert.assertEquals((long)-1L, (long)ret);
        this.assertErrMsg("safemode: FileSystem file:/// is not an HDFS file system. The fs class is: org.apache.hadoop.fs.LocalFileSystem", 0);
    }

    @Test
    public void testGetSafemodeWithoutMountLinksConfigured() throws Exception {
        try (DFSAdmin dfsAdmin = new DFSAdmin(this.conf);){
            this.redirectStream();
            int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-fs", this.defaultFSURI.toString(), "-safemode", "get"});
            this.assertOutMsg("Safe mode is OFF", 0);
            Assert.assertEquals((long)0L, (long)ret);
        }
    }

    @Test
    public void testAllowAndDisalllowSnapShot() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getHost(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        this.redirectStream();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-fs", this.defaultFSURI.toString(), "-allowSnapshot", "/"});
        this.assertOutMsg("Allowing snapshot on / succeeded", 0);
        Assert.assertEquals((long)0L, (long)ret);
        ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-fs", this.defaultFSURI.toString(), "-disallowSnapshot", "/"});
        this.assertOutMsg("Disallowing snapshot on / succeeded", 1);
        Assert.assertEquals((long)0L, (long)ret);
    }

    @Test
    public void testSetBalancerBandwidth() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getHost(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        DFSAdmin dfsAdmin = new DFSAdmin(this.conf);
        this.redirectStream();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-fs", this.defaultFSURI.toString(), "-setBalancerBandwidth", "1000"});
        this.assertOutMsg("Balancer bandwidth is set to 1000", 0);
        Assert.assertEquals((long)0L, (long)ret);
    }
}

