/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.io.IOException;
import java.util.EnumMap;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.AvailableSpaceResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.resolver.order.HashFirstResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.HashResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.LocalResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.OrderedResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.RandomResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleDestinationMountTableResolver
extends MountTableResolver {
    private static final Logger LOG = LoggerFactory.getLogger(MultipleDestinationMountTableResolver.class);
    private EnumMap<DestinationOrder, OrderedResolver> orderedResolvers = new EnumMap(DestinationOrder.class);

    public MultipleDestinationMountTableResolver(Configuration conf, Router router) {
        super(conf, router);
        this.addResolver(DestinationOrder.HASH, new HashFirstResolver());
        this.addResolver(DestinationOrder.LOCAL, new LocalResolver(conf, router));
        this.addResolver(DestinationOrder.RANDOM, new RandomResolver());
        this.addResolver(DestinationOrder.HASH_ALL, new HashResolver());
        this.addResolver(DestinationOrder.SPACE, new AvailableSpaceResolver(conf, router));
    }

    @Override
    public PathLocation getDestinationForPath(String path) throws IOException {
        PathLocation mountTableResult = super.getDestinationForPath(path);
        if (mountTableResult == null) {
            LOG.error("The {} cannot find a location for {}", (Object)super.getClass().getSimpleName(), (Object)path);
        } else if (mountTableResult.hasMultipleDestinations()) {
            DestinationOrder order = mountTableResult.getDestinationOrder();
            OrderedResolver orderedResolver = this.orderedResolvers.get((Object)order);
            if (orderedResolver == null) {
                LOG.error("Cannot find resolver for order {}", (Object)order);
            } else {
                String firstNamespace = orderedResolver.getFirstNamespace(path, mountTableResult);
                if (firstNamespace != null) {
                    mountTableResult = PathLocation.prioritizeDestination(mountTableResult, firstNamespace);
                    LOG.debug("Ordered locations following {} are {}", (Object)order, (Object)mountTableResult);
                } else {
                    LOG.error("Cannot get main namespace for path {} with order {}", (Object)path, (Object)order);
                }
            }
        }
        return mountTableResult;
    }

    @VisibleForTesting
    public void addResolver(DestinationOrder order, OrderedResolver resolver) {
        this.orderedResolvers.put(order, resolver);
    }
}

