/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.manager;

import java.nio.ByteBuffer;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContextValidator;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.FederationPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolicyManager
implements FederationPolicyManager {
    private String queue;
    protected Class routerFederationPolicy;
    protected Class amrmProxyFederationPolicy;
    public static final Logger LOG = LoggerFactory.getLogger(AbstractPolicyManager.class);

    @Override
    public FederationAMRMProxyPolicy getAMRMPolicy(FederationPolicyInitializationContext federationPolicyContext, FederationAMRMProxyPolicy oldInstance) throws FederationPolicyInitializationException {
        if (this.amrmProxyFederationPolicy == null) {
            throw new FederationPolicyInitializationException("The parameter amrmProxyFederationPolicy should be initialized in " + this.getClass().getSimpleName() + " constructor.");
        }
        try {
            return (FederationAMRMProxyPolicy)this.internalPolicyGetter(federationPolicyContext, oldInstance, this.amrmProxyFederationPolicy);
        }
        catch (ClassCastException e) {
            throw new FederationPolicyInitializationException(e);
        }
    }

    @Override
    public FederationRouterPolicy getRouterPolicy(FederationPolicyInitializationContext federationPolicyContext, FederationRouterPolicy oldInstance) throws FederationPolicyInitializationException {
        if (this.routerFederationPolicy == null) {
            throw new FederationPolicyInitializationException("The policy type should be initialized in " + this.getClass().getSimpleName() + " constructor.");
        }
        try {
            return (FederationRouterPolicy)this.internalPolicyGetter(federationPolicyContext, oldInstance, this.routerFederationPolicy);
        }
        catch (ClassCastException e) {
            throw new FederationPolicyInitializationException(e);
        }
    }

    @Override
    public SubClusterPolicyConfiguration serializeConf() throws FederationPolicyInitializationException {
        ByteBuffer buf = ByteBuffer.allocate(0);
        return SubClusterPolicyConfiguration.newInstance(this.getQueue(), this.getClass().getCanonicalName(), buf);
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    @Override
    public void setQueue(String queue) {
        this.queue = queue;
    }

    private ConfigurableFederationPolicy internalPolicyGetter(FederationPolicyInitializationContext federationPolicyContext, ConfigurableFederationPolicy oldInstance, Class policy) throws FederationPolicyInitializationException {
        FederationPolicyInitializationContextValidator.validate(federationPolicyContext, this.getClass().getCanonicalName());
        if (oldInstance == null || !oldInstance.getClass().equals(policy)) {
            try {
                oldInstance = (ConfigurableFederationPolicy)policy.newInstance();
            }
            catch (InstantiationException e) {
                throw new FederationPolicyInitializationException(e);
            }
            catch (IllegalAccessException e) {
                throw new FederationPolicyInitializationException(e);
            }
        }
        FederationPolicyInitializationContext modifiedContext = this.updateContext(federationPolicyContext, oldInstance.getClass().getCanonicalName());
        oldInstance.reinitialize(modifiedContext);
        return oldInstance;
    }

    private FederationPolicyInitializationContext updateContext(FederationPolicyInitializationContext federationPolicyContext, String type) {
        SubClusterPolicyConfiguration newConf = SubClusterPolicyConfiguration.newInstance(federationPolicyContext.getSubClusterPolicyConfiguration());
        newConf.setType(type);
        return new FederationPolicyInitializationContext(newConf, federationPolicyContext.getFederationSubclusterResolver(), federationPolicyContext.getFederationStateStoreFacade(), federationPolicyContext.getHomeSubcluster());
    }

    @Override
    public abstract WeightedPolicyInfo getWeightedPolicyInfo();

    @Override
    public abstract void setWeightedPolicyInfo(WeightedPolicyInfo var1);
}

