/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.AbstractConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;

public abstract class AbstractRouterPolicy
extends AbstractConfigurableFederationPolicy
implements FederationRouterPolicy {
    @Override
    public void validate(WeightedPolicyInfo newPolicyInfo) throws FederationPolicyInitializationException {
        super.validate(newPolicyInfo);
        Map<SubClusterIdInfo, Float> newWeights = newPolicyInfo.getRouterPolicyWeights();
        if (newWeights == null || newWeights.size() < 1) {
            throw new FederationPolicyInitializationException("Weight vector cannot be null/empty.");
        }
    }

    public void validate(ApplicationSubmissionContext appSubmissionContext) throws FederationPolicyException {
        if (appSubmissionContext == null) {
            throw new FederationPolicyException("Cannot route an application with null context.");
        }
        String queue = appSubmissionContext.getQueue();
        if (queue == null) {
            appSubmissionContext.setQueue("default");
        }
    }

    protected abstract SubClusterId chooseSubCluster(String var1, Map<SubClusterId, SubClusterInfo> var2) throws YarnException;

    protected Map<SubClusterId, SubClusterInfo> prefilterSubClusters(ReservationId reservationId, Map<SubClusterId, SubClusterInfo> activeSubClusters) throws YarnException {
        if (reservationId != null) {
            FederationStateStoreFacade stateStoreFacade = this.getPolicyContext().getFederationStateStoreFacade();
            SubClusterId resSubCluster = stateStoreFacade.getReservationHomeSubCluster(reservationId);
            SubClusterInfo subClusterInfo = activeSubClusters.get(resSubCluster);
            return Collections.singletonMap(resSubCluster, subClusterInfo);
        }
        return activeSubClusters;
    }

    @Override
    public SubClusterId getHomeSubcluster(ApplicationSubmissionContext appContext, List<SubClusterId> blackLists) throws YarnException {
        this.validate(appContext);
        Map<SubClusterId, SubClusterInfo> filteredSubClusters = this.prefilterSubClusters(appContext.getReservationID(), this.getActiveSubclusters());
        FederationPolicyUtils.validateSubClusterAvailability(filteredSubClusters.keySet(), blackLists);
        if (blackLists != null) {
            blackLists.forEach(filteredSubClusters::remove);
        }
        return this.chooseSubCluster(appContext.getQueue(), filteredSubClusters);
    }

    @Override
    public SubClusterId getReservationHomeSubcluster(ReservationSubmissionRequest request) throws YarnException {
        if (request == null) {
            throw new FederationPolicyException("The ReservationSubmissionRequest cannot be null.");
        }
        if (request.getQueue() == null) {
            request.setQueue("default");
        }
        Map<SubClusterId, SubClusterInfo> filteredSubClusters = this.getActiveSubclusters();
        return this.chooseSubCluster(request.getQueue(), filteredSubClusters);
    }
}

