/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class SubClusterPolicyConfiguration {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static SubClusterPolicyConfiguration newInstance(String queue, String policyType, ByteBuffer policyParams) {
        SubClusterPolicyConfiguration policy = (SubClusterPolicyConfiguration)Records.newRecord(SubClusterPolicyConfiguration.class);
        policy.setQueue(queue);
        policy.setType(policyType);
        policy.setParams(policyParams);
        return policy;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static SubClusterPolicyConfiguration newInstance(SubClusterPolicyConfiguration conf) {
        SubClusterPolicyConfiguration policy = (SubClusterPolicyConfiguration)Records.newRecord(SubClusterPolicyConfiguration.class);
        policy.setQueue(conf.getQueue());
        policy.setType(conf.getType());
        policy.setParams(conf.getParams());
        return policy;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getQueue();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueue(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getType();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setType(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ByteBuffer getParams();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setParams(ByteBuffer var1);

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.getQueue()).append((Object)this.getParams()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SubClusterPolicyConfiguration) {
            SubClusterPolicyConfiguration other = (SubClusterPolicyConfiguration)obj;
            return new EqualsBuilder().append((Object)this.getType(), (Object)other.getType()).append((Object)this.getQueue(), (Object)other.getQueue()).append((Object)this.getParams(), (Object)other.getParams()).isEquals();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubClusterPolicyConfiguration: [").append("Type: ").append(this.getType()).append(", ").append("Queue: ").append(this.getQueue()).append(", ").append("Params: ").append(this.getParams()).append(", ").append("]");
        return sb.toString();
    }
}

