/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class FedBalanceOptions {
    public static final Option FORCE_CLOSE_OPEN = new Option("forceCloseOpen", false, "Force close all open files if the src and dst are synced.");
    public static final Option MAP = new Option("map", true, "Max number of concurrent maps to use for copy");
    public static final Option BANDWIDTH = new Option("bandwidth", true, "Specify bandwidth per map in MB.");
    public static final Option DELAY_DURATION = new Option("delay", true, "This specifies the delayed duration(millie seconds) when the job needs to retry. A job may retry many times and check the state when it waits for the distcp job to finish.");
    public static final Option DIFF_THRESHOLD = new Option("diffThreshold", true, "This specifies the threshold of the diff entries that used in incremental copy stage. If the diff entries size is no greater than this threshold and the open files check is satisfied(no open files or force close all open files), the fedBalance will go to the final round of distcp. Default value is 0, that means waiting until there is no diff.");
    public static final Option TRASH = new Option("moveToTrash", true, "Move the source path to trash, or delete the source path directly, or skip both trash and deletion. This accepts 3 values: trash, delete and skip. By default the server side trash interval is used. If the trash is disabled in the server side, the default trash interval 60 minutes is used.");
    public static final Options CLI_OPTIONS = new Options();

    private FedBalanceOptions() {
    }

    static {
        CLI_OPTIONS.addOption(FORCE_CLOSE_OPEN);
        CLI_OPTIONS.addOption(MAP);
        CLI_OPTIONS.addOption(BANDWIDTH);
        CLI_OPTIONS.addOption(DELAY_DURATION);
        CLI_OPTIONS.addOption(TRASH);
    }
}

