/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.type.context.NumberContext;

abstract class OptimisationUtils {
    private static final double _32_0 = PrimitiveMath.EIGHT + PrimitiveMath.EIGHT + PrimitiveMath.EIGHT + PrimitiveMath.EIGHT;
    static final NumberContext DISPLAY = NumberContext.getGeneral(6);

    static int getAdjustmentExponent(double largest, double smallest) {
        double tmpSmallestExp;
        double tmpLargestExp = largest > PrimitiveMath.ZERO ? PrimitiveFunction.LOG10.invoke(largest) : PrimitiveMath.ZERO;
        double d = tmpSmallestExp = smallest > PrimitiveMath.ZERO ? PrimitiveFunction.LOG10.invoke(smallest) : -PrimitiveMath.EIGHT;
        if (tmpLargestExp - tmpSmallestExp > _32_0) {
            return 0;
        }
        double tmpNegatedAverage = (tmpLargestExp + tmpSmallestExp) / -PrimitiveMath.TWO;
        return (int)PrimitiveFunction.RINT.invoke(tmpNegatedAverage);
    }

    private OptimisationUtils() {
    }
}

