/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.IntIndex;
import org.ojalgo.access.IntRowColumn;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.optimisation.BaseSolver;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.convex.IterativeMixedASS;
import org.ojalgo.optimisation.convex.IterativePureASS;
import org.ojalgo.optimisation.convex.QPESolver;
import org.ojalgo.optimisation.convex.UnconstrainedSolver;
import org.ojalgo.scalar.ComplexNumber;

public abstract class ConvexSolver
extends BaseSolver {
    static final PhysicalStore.Factory<Double, PrimitiveDenseStore> FACTORY = PrimitiveDenseStore.FACTORY;
    final Cholesky<Double> myCholesky;
    final LU<Double> myLU;

    public static void copy(ExpressionsBasedModel sourceModel, Builder destinationBuilder) {
        List<Variable> tmpFreeVariables = sourceModel.getFreeVariables();
        Set<IntIndex> tmpFixedVariables = sourceModel.getFixedVariables();
        int tmpFreeVarDim = tmpFreeVariables.size();
        List tmpEqExpr = sourceModel.constraints().filter(c -> c.isEqualityConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int tmpEqExprDim = tmpEqExpr.size();
        if (tmpEqExprDim > 0) {
            SparseStore<Double> tmpAE = SparseStore.PRIMITIVE.make(tmpEqExprDim, tmpFreeVarDim);
            PhysicalStore tmpBE = (PhysicalStore)FACTORY.makeZero(tmpEqExprDim, 1L);
            for (int i = 0; i < tmpEqExprDim; ++i) {
                Expression tmpExpression = ((Expression)tmpEqExpr.get(i)).compensate(tmpFixedVariables);
                for (IntIndex intIndex : tmpExpression.getLinearKeySet()) {
                    int tmpIndex = sourceModel.indexOfFreeVariable(intIndex.index);
                    if (tmpIndex < 0) continue;
                    tmpAE.set((long)i, (long)tmpIndex, tmpExpression.getAdjustedLinearFactor(intIndex));
                }
                tmpBE.set((long)i, 0L, tmpExpression.getAdjustedUpperLimit());
            }
            destinationBuilder.equalities(tmpAE, (MatrixStore)tmpBE);
        }
        Expression tmpObjExpr = sourceModel.objective().compensate(tmpFixedVariables);
        PhysicalStore tmpQ = null;
        if (tmpObjExpr.isAnyQuadraticFactorNonZero()) {
            tmpQ = (PhysicalStore)FACTORY.makeZero(tmpFreeVarDim, tmpFreeVarDim);
            PrimitiveFunction.Binary tmpBaseFunc = sourceModel.isMaximisation() ? PrimitiveFunction.SUBTRACT : PrimitiveFunction.ADD;
            for (IntRowColumn intRowColumn : tmpObjExpr.getQuadraticKeySet()) {
                int tmpRow = sourceModel.indexOfFreeVariable(intRowColumn.row);
                int tmpColumn = sourceModel.indexOfFreeVariable(intRowColumn.column);
                if (tmpRow < 0 || tmpColumn < 0) continue;
                UnaryFunction<double> tmpModifier = tmpBaseFunc.second(tmpObjExpr.getAdjustedQuadraticFactor(intRowColumn));
                tmpQ.modifyOne(tmpRow, tmpColumn, tmpModifier);
                tmpQ.modifyOne(tmpColumn, tmpRow, tmpModifier);
            }
        }
        PhysicalStore tmpC = null;
        if (tmpObjExpr.isAnyLinearFactorNonZero()) {
            tmpC = (PhysicalStore)FACTORY.makeZero(tmpFreeVarDim, 1L);
            if (sourceModel.isMinimisation()) {
                for (IntIndex tmpKey : tmpObjExpr.getLinearKeySet()) {
                    int n = sourceModel.indexOfFreeVariable(tmpKey.index);
                    if (n < 0) continue;
                    tmpC.set((long)n, 0L, -tmpObjExpr.getAdjustedLinearFactor(tmpKey));
                }
            } else {
                for (IntIndex tmpKey : tmpObjExpr.getLinearKeySet()) {
                    int n = sourceModel.indexOfFreeVariable(tmpKey.index);
                    if (n < 0) continue;
                    tmpC.set((long)n, 0L, tmpObjExpr.getAdjustedLinearFactor(tmpKey));
                }
            }
        }
        destinationBuilder.objective((MatrixStore)tmpQ, (MatrixStore)tmpC);
        List tmpUpExpr = sourceModel.constraints().filter(c2 -> c2.isUpperConstraint() && !c2.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int tmpUpExprDim = tmpUpExpr.size();
        List list = sourceModel.bounds().filter(c4 -> c4.isUpperConstraint()).collect(Collectors.toList());
        int tmpUpVarDim = list.size();
        List tmpLoExpr = sourceModel.constraints().filter(c1 -> c1.isLowerConstraint() && !c1.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int tmpLoExprDim = tmpLoExpr.size();
        List tmpLoVar = sourceModel.bounds().filter(c3 -> c3.isLowerConstraint()).collect(Collectors.toList());
        int tmpLoVarDim = tmpLoVar.size();
        if (tmpUpExprDim + tmpUpVarDim + tmpLoExprDim + tmpLoVarDim > 0) {
            Variable tmpVariable;
            int tmpIndex;
            Expression tmpExpression;
            int i;
            SparseStore<Double> tmpAI = SparseStore.PRIMITIVE.make(tmpUpExprDim + tmpUpVarDim + tmpLoExprDim + tmpLoVarDim, tmpFreeVarDim);
            PhysicalStore tmpBI = (PhysicalStore)FACTORY.makeZero(tmpUpExprDim + tmpUpVarDim + tmpLoExprDim + tmpLoVarDim, 1L);
            if (tmpUpExprDim > 0) {
                for (i = 0; i < tmpUpExprDim; ++i) {
                    tmpExpression = ((Expression)tmpUpExpr.get(i)).compensate(tmpFixedVariables);
                    for (IntIndex tmpKey : tmpExpression.getLinearKeySet()) {
                        tmpIndex = sourceModel.indexOfFreeVariable(tmpKey.index);
                        if (tmpIndex < 0) continue;
                        tmpAI.set((long)i, (long)tmpIndex, tmpExpression.getAdjustedLinearFactor(tmpKey));
                    }
                    tmpBI.set((long)i, 0L, tmpExpression.getAdjustedUpperLimit());
                }
            }
            if (tmpUpVarDim > 0) {
                for (i = 0; i < tmpUpVarDim; ++i) {
                    tmpVariable = (Variable)list.get(i);
                    tmpAI.set((long)(tmpUpExprDim + i), (long)sourceModel.indexOfFreeVariable(tmpVariable), tmpVariable.getAdjustmentFactor());
                    tmpBI.set((long)(tmpUpExprDim + i), 0L, tmpVariable.getAdjustedUpperLimit());
                }
            }
            if (tmpLoExprDim > 0) {
                for (i = 0; i < tmpLoExprDim; ++i) {
                    tmpExpression = ((Expression)tmpLoExpr.get(i)).compensate(tmpFixedVariables);
                    for (IntIndex tmpKey : tmpExpression.getLinearKeySet()) {
                        tmpIndex = sourceModel.indexOfFreeVariable(tmpKey.index);
                        if (tmpIndex < 0) continue;
                        tmpAI.set((long)(tmpUpExprDim + tmpUpVarDim + i), (long)tmpIndex, -tmpExpression.getAdjustedLinearFactor(tmpKey));
                    }
                    tmpBI.set((long)(tmpUpExprDim + tmpUpVarDim + i), 0L, -tmpExpression.getAdjustedLowerLimit());
                }
            }
            if (tmpLoVarDim > 0) {
                for (i = 0; i < tmpLoVarDim; ++i) {
                    tmpVariable = (Variable)tmpLoVar.get(i);
                    tmpAI.set((long)(tmpUpExprDim + tmpUpVarDim + tmpLoExprDim + i), (long)sourceModel.indexOfFreeVariable(tmpVariable), -tmpVariable.getAdjustmentFactor());
                    tmpBI.set((long)(tmpUpExprDim + tmpUpVarDim + tmpLoExprDim + i), 0L, -tmpVariable.getAdjustedLowerLimit());
                }
            }
            destinationBuilder.inequalities(tmpAI, (MatrixStore)tmpBI);
        }
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static Builder getBuilder(MatrixStore<Double> Q, MatrixStore<Double> C) {
        return ConvexSolver.getBuilder().objective((MatrixStore)Q, (MatrixStore)C);
    }

    protected ConvexSolver(Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
        MatrixStore<Double> tmpQ = this.getQ();
        this.myCholesky = Cholesky.make(tmpQ);
        this.myLU = LU.make(tmpQ);
    }

    @Override
    public final Optimisation.Result solve(Optimisation.Result kickStarter) {
        boolean tmpContinue = true;
        if (this.options.validate) {
            tmpContinue = this.validate();
        }
        if (tmpContinue) {
            tmpContinue = this.initialise(kickStarter);
        }
        if (tmpContinue) {
            this.resetIterationsCount();
            do {
                this.performIteration();
                this.incrementIterationsCount();
            } while (!this.getState().isFailure() && this.needsAnotherIteration() && this.isIterationAllowed());
        }
        return this.buildResult();
    }

    @Override
    protected double evaluateFunction(Access1D<?> solution) {
        PhysicalStore<Double> tmpX = this.getX();
        return tmpX.transpose().multiply(this.getQ().multiply((Double)((Object)tmpX))).multiply(0.5).subtract(tmpX.transpose().multiply(this.getC())).doubleValue(0L);
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return this.getX().copy();
    }

    protected abstract MatrixStore<Double> getIterationKKT();

    protected abstract MatrixStore<Double> getIterationRHS();

    protected abstract void performIteration();

    @Override
    protected boolean validate() {
        MatrixStore<Double> tmpQ = this.getQ();
        MatrixStore<Double> tmpC = this.getC();
        if (tmpQ == null || tmpC == null) {
            throw new IllegalArgumentException("Neither Q nor C may be null!");
        }
        if (!MatrixUtils.isHermitian(tmpQ)) {
            if (this.isDebug()) {
                this.debug("Q not symmetric!", tmpQ);
            }
            throw new IllegalArgumentException("Q must be symmetric!");
        }
        if (!this.myCholesky.isSPD()) {
            Eigenvalue<Double> tmpEvD = Eigenvalue.PRIMITIVE.make(true);
            tmpEvD.computeValuesOnly(tmpQ);
            Array1D<ComplexNumber> tmpEigenvalues = tmpEvD.getEigenvalues();
            tmpEvD.reset();
            for (ComplexNumber tmpValue : tmpEigenvalues) {
                if (!(tmpValue.doubleValue() < PrimitiveMath.ZERO) && tmpValue.isReal()) continue;
                if (this.isDebug()) {
                    this.debug("Q not positive semidefinite!", new Object[0]);
                    this.debug("The eigenvalues are: {}", tmpEigenvalues);
                }
                throw new IllegalArgumentException("Q must be positive semidefinite!");
            }
        }
        this.setState(Optimisation.State.VALID);
        return true;
    }

    public static final class Builder
    extends BaseSolver.AbstractBuilder<Builder, ConvexSolver> {
        public Builder(MatrixStore<Double> Q, MatrixStore<Double> C) {
            super(Q, C);
        }

        Builder() {
        }

        Builder(Builder matrices) {
            super(matrices);
        }

        Builder(MatrixStore<Double> C) {
            super(C);
        }

        Builder(MatrixStore<Double>[] aMtrxArr) {
            super(aMtrxArr);
        }

        @Override
        public ConvexSolver build(Optimisation.Options options) {
            this.validate();
            if (this.hasInequalityConstraints()) {
                if (this.hasEqualityConstraints()) {
                    return new IterativeMixedASS(this, options);
                }
                return new IterativePureASS(this, options);
            }
            if (this.hasEqualityConstraints()) {
                return new QPESolver(this, options);
            }
            return new UnconstrainedSolver(this, options);
        }

        @Override
        public Builder equalities(MatrixStore<Double> AE, MatrixStore<Double> BE) {
            return (Builder)super.equalities(AE, BE);
        }

        @Override
        public Builder inequalities(MatrixStore<Double> AI, MatrixStore<Double> BI) {
            return (Builder)super.inequalities(AI, BI);
        }

        @Override
        public Builder objective(MatrixStore<Double> Q, MatrixStore<Double> C) {
            return (Builder)super.objective(Q, C);
        }
    }
}

