/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.util.MakeUniqueClassName;

public class NameHelper {
    public static final String ILLEGAL_CHARACTER_REGEX = "[^0-9a-zA-Z_$]";
    private final GenerationConfig generationConfig;

    public NameHelper(GenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
    }

    public String replaceIllegalCharacters(String name) {
        return name.replaceAll(ILLEGAL_CHARACTER_REGEX, "_");
    }

    public String normalizeName(String name) {
        if (Character.isDigit((name = this.capitalizeTrailingWords(name)).charAt(0))) {
            name = "_" + name;
        }
        return name;
    }

    public String capitalizeTrailingWords(String name) {
        char[] wordDelimiters = this.generationConfig.getPropertyWordDelimiters();
        if (StringUtils.containsAny((CharSequence)name, (char[])wordDelimiters)) {
            String capitalizedNodeName = this.areAllWordsUpperCaseBesideDelimiters(name, wordDelimiters) ? WordUtils.capitalizeFully((String)name, (char[])wordDelimiters) : WordUtils.capitalize((String)name, (char[])wordDelimiters);
            name = name.charAt(0) + capitalizedNodeName.substring(1);
            for (char c : wordDelimiters) {
                name = StringUtils.remove((String)name, (char)c);
            }
        } else if (this.areAllWordsUpperCaseBesideDelimiters(name, wordDelimiters)) {
            name = WordUtils.capitalizeFully((String)name, (char[])wordDelimiters);
        }
        return name;
    }

    private boolean areAllWordsUpperCaseBesideDelimiters(String words, char ... delimiters) {
        char[] wordChars;
        for (char c : wordChars = words.toCharArray()) {
            if (StringUtils.containsAny((CharSequence)("" + c), (char[])delimiters) || !Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private String makeLowerCamelCase(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public String getPropertyName(String jsonFieldName, JsonNode node) {
        jsonFieldName = this.getFieldName(jsonFieldName, node);
        jsonFieldName = this.replaceIllegalCharacters(jsonFieldName);
        jsonFieldName = this.normalizeName(jsonFieldName);
        if (SourceVersion.isKeyword(jsonFieldName = this.makeLowerCamelCase(jsonFieldName))) {
            jsonFieldName = "_" + jsonFieldName;
        }
        if (SourceVersion.isKeyword(jsonFieldName)) {
            jsonFieldName = jsonFieldName + "_";
        }
        return jsonFieldName;
    }

    public String getSetterName(String propertyName, JsonNode node) {
        propertyName = this.getPropertyNameForAccessor(propertyName, node);
        String prefix = "set";
        String setterName = propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1)) ? prefix + propertyName : prefix + StringUtils.capitalize((String)propertyName);
        if (setterName.equals("setClass")) {
            setterName = "setClass_";
        }
        return setterName;
    }

    public String getBuilderName(String propertyName, JsonNode node) {
        propertyName = this.getPropertyNameForAccessor(propertyName, node);
        String prefix = "with";
        if (propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1))) {
            return prefix + propertyName;
        }
        return prefix + StringUtils.capitalize((String)propertyName);
    }

    public String getFieldName(String propertyName, JsonNode node) {
        if (node != null && node.has("javaName")) {
            propertyName = node.get("javaName").textValue();
        }
        return propertyName;
    }

    public String getClassName(String propertyName, JsonNode node) {
        if (node != null) {
            if (node.has("javaName")) {
                propertyName = node.get("javaName").textValue();
            } else if (this.generationConfig.isUseTitleAsClassname() && node.has("title")) {
                String title = node.get("title").textValue();
                propertyName = WordUtils.capitalize((String)title).replaceAll(" ", "");
            }
        }
        return propertyName;
    }

    public String getGetterName(String propertyName, JType type, JsonNode node) {
        propertyName = this.getPropertyNameForAccessor(propertyName, node);
        String prefix = type.equals(type.owner()._ref(Boolean.TYPE)) ? "is" : "get";
        String getterName = propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1)) ? prefix + propertyName : prefix + StringUtils.capitalize((String)propertyName);
        if (getterName.equals("getClass")) {
            getterName = "getClass_";
        }
        return getterName;
    }

    private String getPropertyNameForAccessor(String jsonPropertyName, JsonNode node) {
        jsonPropertyName = this.getFieldName(jsonPropertyName, node);
        jsonPropertyName = this.replaceIllegalCharacters(jsonPropertyName);
        jsonPropertyName = this.capitalizeTrailingWords(jsonPropertyName);
        return jsonPropertyName;
    }

    public String getBuilderClassName(JClass outterClass) {
        return outterClass.name() + "Builder";
    }

    public String getUniqueClassName(String nodeName, JsonNode node, JPackage _package) {
        return this.makeUnique(this.getClassName(nodeName, node, _package), _package);
    }

    public String getClassName(String nodeName, JsonNode node, JPackage _package) {
        String prefix = this.generationConfig.getClassNamePrefix();
        String suffix = this.generationConfig.getClassNameSuffix();
        String fieldName = this.getClassName(nodeName, node);
        String capitalizedFieldName = StringUtils.capitalize((String)fieldName);
        String fullFieldName = this.createFullFieldName(capitalizedFieldName, prefix, suffix);
        String className = this.replaceIllegalCharacters(fullFieldName);
        return this.normalizeName(className);
    }

    private String createFullFieldName(String nodeName, String prefix, String suffix) {
        String returnString = nodeName;
        if (prefix != null) {
            returnString = prefix + returnString;
        }
        if (suffix != null) {
            returnString = returnString + suffix;
        }
        return returnString;
    }

    private String makeUnique(String className, JPackage _package) {
        try {
            JDefinedClass _class = _package._class(className);
            _package.remove((JClass)_class);
            return className;
        }
        catch (JClassAlreadyExistsException e) {
            return this.makeUnique(MakeUniqueClassName.makeUnique(className), _package);
        }
    }
}

