/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.constants;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class FileSystemConfigurations {
    public static final String DEFAULT_FS_AZURE_ACCOUNT_IS_HNS_ENABLED = "";
    public static final boolean DEFAULT_FS_AZURE_ENABLE_DFSTOBLOB_FALLBACK = false;
    public static final boolean DEFAULT_FS_AZURE_ACCOUNT_IS_EXPECT_HEADER_ENABLED = true;
    public static final String USER_HOME_DIRECTORY_PREFIX = "/user";
    private static final int SIXTY_SECONDS = 60000;
    public static final int DEFAULT_MIN_BACKOFF_INTERVAL = 500;
    public static final int DEFAULT_MAX_BACKOFF_INTERVAL = 25000;
    public static final boolean DEFAULT_STATIC_RETRY_FOR_CONNECTION_TIMEOUT_ENABLED = true;
    public static final int DEFAULT_STATIC_RETRY_INTERVAL = 1000;
    public static final int DEFAULT_BACKOFF_INTERVAL = 500;
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 30;
    public static final int DEFAULT_CUSTOM_TOKEN_FETCH_RETRY_COUNT = 3;
    public static final int DEFAULT_HTTP_CONNECTION_TIMEOUT = 2000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 30000;
    public static final int DEFAULT_AZURE_OAUTH_TOKEN_FETCH_RETRY_MAX_ATTEMPTS = 5;
    public static final int DEFAULT_AZURE_OAUTH_TOKEN_FETCH_RETRY_MIN_BACKOFF_INTERVAL = 0;
    public static final int DEFAULT_AZURE_OAUTH_TOKEN_FETCH_RETRY_MAX_BACKOFF_INTERVAL = 60000;
    public static final int DEFAULT_AZURE_OAUTH_TOKEN_FETCH_RETRY_DELTA_BACKOFF = 2;
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 0x800000;
    public static final int APPENDBLOB_MAX_WRITE_BUFFER_SIZE = 0x400000;
    public static final boolean DEFAULT_AZURE_ENABLE_SMALL_WRITE_OPTIMIZATION = false;
    public static final int DEFAULT_READ_BUFFER_SIZE = 0x400000;
    public static final boolean DEFAULT_READ_SMALL_FILES_COMPLETELY = false;
    public static final boolean DEFAULT_OPTIMIZE_FOOTER_READ = true;
    public static final int DEFAULT_FOOTER_READ_BUFFER_SIZE = 524288;
    public static final boolean DEFAULT_ALWAYS_READ_BUFFER_SIZE = false;
    public static final int DEFAULT_READ_AHEAD_BLOCK_SIZE = 0x400000;
    public static final int DEFAULT_READ_AHEAD_RANGE = 65536;
    public static final int MIN_BUFFER_SIZE = 16384;
    public static final int MAX_BUFFER_SIZE = 0x6400000;
    public static final long MAX_AZURE_BLOCK_SIZE = 0x10000000L;
    public static final String AZURE_BLOCK_LOCATION_HOST_DEFAULT = "localhost";
    public static final int DEFAULT_AZURE_LIST_MAX_RESULTS = 5000;
    public static final String SERVER_SIDE_ENCRYPTION_ALGORITHM = "AES256";
    public static final int MAX_CONCURRENT_READ_THREADS = 12;
    public static final int MAX_CONCURRENT_WRITE_THREADS = 8;
    public static final boolean DEFAULT_READ_TOLERATE_CONCURRENT_APPEND = false;
    public static final boolean DEFAULT_AZURE_CREATE_REMOTE_FILESYSTEM_DURING_INITIALIZATION = false;
    public static final boolean DEFAULT_AZURE_SKIP_USER_GROUP_METADATA_DURING_INITIALIZATION = false;
    public static final String DEFAULT_FS_AZURE_ATOMIC_RENAME_DIRECTORIES = "/hbase";
    public static final boolean DEFAULT_FS_AZURE_ENABLE_CONDITIONAL_CREATE_OVERWRITE = true;
    public static final boolean DEFAULT_FS_AZURE_ENABLE_MKDIR_OVERWRITE = true;
    public static final String DEFAULT_FS_AZURE_APPEND_BLOB_DIRECTORIES = "";
    public static final String DEFAULT_FS_AZURE_INFINITE_LEASE_DIRECTORIES = "";
    public static final int DEFAULT_LEASE_THREADS = 0;
    public static final int MIN_LEASE_THREADS = 0;
    public static final int DEFAULT_LEASE_DURATION = -1;
    public static final int INFINITE_LEASE_DURATION = -1;
    public static final int MIN_LEASE_DURATION = 15;
    public static final int MAX_LEASE_DURATION = 60;
    public static final int DEFAULT_READ_AHEAD_QUEUE_DEPTH = 2;
    public static final boolean DEFAULT_ENABLE_FLUSH = true;
    public static final boolean DEFAULT_DISABLE_OUTPUTSTREAM_FLUSH = true;
    public static final boolean DEFAULT_ENABLE_AUTOTHROTTLING = false;
    public static final int DEFAULT_METRIC_IDLE_TIMEOUT_MS = 60000;
    public static final int DEFAULT_METRIC_ANALYSIS_TIMEOUT_MS = 60000;
    public static final boolean DEFAULT_FS_AZURE_ACCOUNT_LEVEL_THROTTLING_ENABLED = true;
    public static final int DEFAULT_ACCOUNT_OPERATION_IDLE_TIMEOUT_MS = 60000;
    public static final int DEFAULT_ANALYSIS_PERIOD_MS = 10000;
    public static final DelegatingSSLSocketFactory.SSLChannelMode DEFAULT_FS_AZURE_SSL_CHANNEL_MODE = DelegatingSSLSocketFactory.SSLChannelMode.Default;
    public static final boolean DEFAULT_ENABLE_DELEGATION_TOKEN = false;
    public static final boolean DEFAULT_ENABLE_HTTPS = true;
    public static final boolean DEFAULT_USE_UPN = false;
    public static final boolean DEFAULT_ENABLE_CHECK_ACCESS = true;
    public static final boolean DEFAULT_ABFS_LATENCY_TRACK = false;
    public static final long DEFAULT_SAS_TOKEN_RENEW_PERIOD_FOR_STREAMS_IN_SECONDS = 120L;
    public static final boolean DEFAULT_ENABLE_READAHEAD = true;
    public static final String DEFAULT_FS_AZURE_USER_AGENT_PREFIX = "";
    public static final String DEFAULT_VALUE_UNKNOWN = "UNKNOWN";
    public static final boolean DEFAULT_DELETE_CONSIDERED_IDEMPOTENT = true;
    public static final int DEFAULT_CLOCK_SKEW_WITH_SERVER_IN_MS = 300000;
    public static final int STREAM_ID_LEN = 12;
    public static final boolean DEFAULT_ENABLE_ABFS_LIST_ITERATOR = true;
    public static final boolean DEFAULT_ENABLE_ABFS_RENAME_RESILIENCE = true;
    public static final boolean DEFAULT_ENABLE_PAGINATED_DELETE = false;
    public static final boolean DEFAULT_ENABLE_ABFS_CHECKSUM_VALIDATION = false;
    public static final int BLOCK_UPLOAD_ACTIVE_BLOCKS_DEFAULT = 20;
    public static final int BLOCK_ID_LENGTH = 60;
    public static final String DATA_BLOCKS_BUFFER_DISK = "disk";
    public static final String DATA_BLOCKS_BYTEBUFFER = "bytebuffer";
    public static final String DATA_BLOCKS_BUFFER_DEFAULT = "bytebuffer";
    public static final int RATE_LIMIT_DEFAULT = 1000;
    public static final int ZERO = 0;
    public static final int HUNDRED = 100;
    public static final long THOUSAND = 1000L;
    public static final HttpOperationType DEFAULT_NETWORKING_LIBRARY = HttpOperationType.JDK_HTTP_URL_CONNECTION;
    public static final int DEFAULT_APACHE_HTTP_CLIENT_MAX_IO_EXCEPTION_RETRIES = 3;
    public static final long DEFAULT_HTTP_CLIENT_CONN_MAX_IDLE_TIME = 5000L;
    public static final int DEFAULT_HTTP_CLIENT_CONN_MAX_CACHED_CONNECTIONS = 5;
    public static final long DEFAULT_AZURE_BLOB_COPY_PROGRESS_WAIT_MILLIS = 1000L;
    public static final long DEFAULT_AZURE_BLOB_COPY_MAX_WAIT_MILLIS = 300000L;
    public static final long DEFAULT_AZURE_BLOB_ATOMIC_RENAME_LEASE_REFRESH_DURATION = 60000L;
    public static final int DEFAULT_FS_AZURE_PRODUCER_QUEUE_MAX_SIZE = 10000;
    public static final int DEFAULT_FS_AZURE_CONSUMER_MAX_LAG = 5000;
    public static final int DEFAULT_FS_AZURE_LISTING_ACTION_THREADS = 5;
    public static final int DEFAULT_FS_AZURE_BLOB_RENAME_THREAD = 5;
    public static final int DEFAULT_FS_AZURE_BLOB_DELETE_THREAD = 5;
    public static final boolean DEFAULT_FS_AZURE_ENABLE_CLIENT_TRANSACTION_ID = true;

    private FileSystemConfigurations() {
    }
}

