/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.ConstantValueStatistic;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.MemoizingValueStatistic;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.StatisticType;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.SuppliedValueStatistic;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.Table;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.ValueStatistic;

public class ValueStatistics {
    public static <T extends Serializable> ConstantValueStatistic<T> nullValue(StatisticType type) {
        return new ConstantValueStatistic<Object>(type, null);
    }

    public static <T extends Serializable> ConstantValueStatistic<T> constant(StatisticType type, T value) {
        return new ConstantValueStatistic<T>(type, value);
    }

    public static <T extends Serializable> ValueStatistic<T> supply(StatisticType type, Supplier<T> supplier) {
        return new SuppliedValueStatistic<T>(type, supplier);
    }

    public static <T extends Number> ValueStatistic<T> gauge(Supplier<T> supplier) {
        return ValueStatistics.supply(StatisticType.GAUGE, supplier);
    }

    public static <T extends Number> ValueStatistic<T> counter(Supplier<T> supplier) {
        return ValueStatistics.supply(StatisticType.COUNTER, supplier);
    }

    public static <T extends Number> ValueStatistic<T> rate(Supplier<T> supplier) {
        return ValueStatistics.supply(StatisticType.RATE, supplier);
    }

    public static <T extends Number> ValueStatistic<T> ratio(Supplier<T> supplier) {
        return ValueStatistics.supply(StatisticType.RATIO, supplier);
    }

    public static <T extends Table> ValueStatistic<T> table(Supplier<T> supplier) {
        return ValueStatistics.supply(StatisticType.TABLE, supplier);
    }

    public static <T extends Serializable> ValueStatistic<T> memoize(long delay, TimeUnit unit, ValueStatistic<T> valueStatistic) {
        return new MemoizingValueStatistic<T>(delay, unit, valueStatistic);
    }
}

