/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSController;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebServices;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.webapp.TimelineWebServices;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.apache.hadoop.yarn.webapp.YarnWebParams;

public class AHSWebApp
extends WebApp
implements YarnWebParams {
    private final ApplicationHistoryClientService historyClientService;
    private TimelineDataManager timelineDataManager;

    public AHSWebApp(TimelineDataManager timelineDataManager, ApplicationHistoryClientService historyClientService) {
        this.timelineDataManager = timelineDataManager;
        this.historyClientService = historyClientService;
    }

    public ApplicationHistoryClientService getApplicationHistoryClientService() {
        return this.historyClientService;
    }

    public TimelineDataManager getTimelineDataManager() {
        return this.timelineDataManager;
    }

    public void setup() {
        this.bind(YarnJacksonJaxbJsonProvider.class);
        this.bind(AHSWebServices.class);
        this.bind(TimelineWebServices.class);
        this.bind(GenericExceptionHandler.class);
        this.bind(ApplicationBaseProtocol.class).toInstance(this.historyClientService);
        this.bind(TimelineDataManager.class).toInstance(this.timelineDataManager);
        this.route("/", AHSController.class);
        this.route("/about", AHSController.class, "about");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/apps", "app.state"}), AHSController.class);
        this.route(StringHelper.pajoin((Object[])new Object[]{"/app", "app.id"}), AHSController.class, "app");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/appattempt", "appattempt.id"}), AHSController.class, "appattempt");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/container", "container.id"}), AHSController.class, "container");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/logs", "nm.id", "container.id", "entity.string", "app.owner", "log.type"}), AHSController.class, "logs");
        this.route("/errors-and-warnings", AHSController.class, "errorsAndWarnings");
    }
}

