/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.io.wrappedio.WrappedIO;
import org.apache.hadoop.io.wrappedio.impl.DynamicWrappedIO;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractBulkDeleteTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractBulkDeleteTest.class);
    protected int pageSize;
    protected Path basePath;
    protected FileSystem fs;
    private DynamicWrappedIO dynamicWrappedIO;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.fs = this.getFileSystem();
        this.basePath = this.path(this.getClass().getName());
        this.dynamicWrappedIO = new DynamicWrappedIO();
        this.pageSize = this.dynamicWrappedIO.bulkDelete_pageSize(this.fs, this.basePath);
        this.fs.mkdirs(this.basePath);
    }

    public Path getBasePath() {
        return this.basePath;
    }

    protected int getExpectedPageSize() {
        return 1;
    }

    @Test
    public void validatePageSize() throws Exception {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.pageSize).describedAs("Page size should be 1 by default for all stores", new Object[0])).isEqualTo(this.getExpectedPageSize());
    }

    @Test
    public void testPathsSizeEqualsPageSizePrecondition() throws Exception {
        List<Path> listOfPaths = this.createListOfPaths(this.pageSize, this.basePath);
        WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, listOfPaths);
    }

    @Test
    public void testPathsSizeGreaterThanPageSizePrecondition() throws Exception {
        List<Path> listOfPaths = this.createListOfPaths(this.pageSize + 1, this.basePath);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.dynamicWrappedIO.bulkDelete_delete(this.getFileSystem(), this.basePath, (Collection)listOfPaths));
    }

    @Test
    public void testPathsSizeLessThanPageSizePrecondition() throws Exception {
        List<Path> listOfPaths = this.createListOfPaths(this.pageSize - 1, this.basePath);
        this.dynamicWrappedIO.bulkDelete_delete(this.getFileSystem(), this.basePath, listOfPaths);
    }

    @Test
    public void testBulkDeleteSuccessful() throws Exception {
        this.runBulkDelete(false);
    }

    @Test
    public void testBulkDeleteSuccessfulUsingDirectFS() throws Exception {
        this.runBulkDelete(true);
    }

    private void runBulkDelete(boolean useDirectFS) throws IOException {
        List<Path> listOfPaths = this.createListOfPaths(this.pageSize, this.basePath);
        for (Path path : listOfPaths) {
            ContractTestUtils.touch(this.fs, path);
        }
        Object[] fileStatuses = this.fs.listStatus(this.basePath);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])fileStatuses).describedAs("File count after create", new Object[0])).hasSize(this.pageSize);
        if (useDirectFS) {
            AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(this.fs.createBulkDelete(this.basePath).bulkDelete(listOfPaths));
        } else {
            AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, listOfPaths));
        }
        Object[] fileStatusesAfterDelete = this.fs.listStatus(this.basePath);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])fileStatusesAfterDelete).describedAs("File statuses should be empty after delete", new Object[0])).isEmpty();
    }

    @Test
    public void validatePathCapabilityDeclared() throws Exception {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fs.hasPathCapability(this.basePath, "fs.capability.bulk.delete")).describedAs("Path capability BULK_DELETE should be declared", new Object[0])).isTrue();
    }

    @Test
    public void testDeletePathsNotUnderBase() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path pathNotUnderBase = this.path("not-under-base");
        paths.add(pathNotUnderBase);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, (Collection)paths));
    }

    @Test
    public void testDeletePathSameAsBasePath() throws Exception {
        AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, Arrays.asList(this.basePath)));
    }

    @Test
    public void testDeletePathsNotAbsolute() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path pathNotAbsolute = new Path("not-absolute");
        paths.add(pathNotAbsolute);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, (Collection)paths));
    }

    @Test
    public void testDeletePathsNotExists() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path pathNotExists = new Path(this.basePath, "not-exists");
        paths.add(pathNotExists);
        AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, paths));
    }

    @Test
    public void testDeletePathsDirectory() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path dirPath = new Path(this.basePath, "dir");
        paths.add(dirPath);
        Path filePath = new Path(dirPath, "file");
        paths.add(filePath);
        this.pageSizePreconditionForTest(paths.size());
        this.fs.mkdirs(dirPath);
        ContractTestUtils.touch(this.fs, filePath);
        AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, paths));
    }

    @Test
    public void testBulkDeleteParentDirectoryWithDirectories() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path dirPath = new Path(this.basePath, "dir");
        this.fs.mkdirs(dirPath);
        Path subDir = new Path(dirPath, "subdir");
        this.fs.mkdirs(subDir);
        paths.add(dirPath);
        List entries = WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, paths);
        ((ListAssert)Assertions.assertThat((List)entries).describedAs("Parent non empty directory should not be deleted", new Object[0])).hasSize(1);
        this.assertIsDirectory(dirPath);
    }

    @Test
    public void testBulkDeleteParentDirectoryWithFiles() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path dirPath = new Path(this.basePath, "dir");
        this.fs.mkdirs(dirPath);
        Path file = new Path(dirPath, "file");
        ContractTestUtils.touch(this.fs, file);
        paths.add(dirPath);
        List entries = WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, paths);
        ((ListAssert)Assertions.assertThat((List)entries).describedAs("Parent non empty directory should not be deleted", new Object[0])).hasSize(1);
        this.assertIsDirectory(dirPath);
    }

    @Test
    public void testDeleteEmptyDirectory() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path emptyDirPath = new Path(this.basePath, "empty-dir");
        this.fs.mkdirs(emptyDirPath);
        paths.add(emptyDirPath);
        AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, paths));
    }

    @Test
    public void testDeleteEmptyList() throws Exception {
        ArrayList paths = new ArrayList();
        AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, paths));
    }

    @Test
    public void testDeleteSamePathsMoreThanOnce() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path path = new Path(this.basePath, "file");
        paths.add(path);
        paths.add(path);
        Path another = new Path(this.basePath, "another-file");
        paths.add(another);
        this.pageSizePreconditionForTest(paths.size());
        ContractTestUtils.touch(this.fs, path);
        ContractTestUtils.touch(this.fs, another);
        AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, paths));
    }

    protected void pageSizePreconditionForTest(int size) {
        if (size > this.pageSize) {
            ContractTestUtils.skip("Test requires paths size less than or equal to page size: " + this.pageSize + "; actual size is " + size);
        }
    }

    @Test
    public void testDeepDirectoryFilesDelete() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path dir1 = new Path(this.basePath, "dir1");
        Path dir2 = new Path(dir1, "dir2");
        Path dir3 = new Path(dir2, "dir3");
        this.fs.mkdirs(dir3);
        Path file1 = new Path(dir3, "file1");
        ContractTestUtils.touch(this.fs, file1);
        paths.add(file1);
        AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, paths));
    }

    @Test
    public void testChildPaths() throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path dirPath = new Path(this.basePath, "dir");
        this.fs.mkdirs(dirPath);
        paths.add(dirPath);
        Path filePath = new Path(dirPath, "file");
        ContractTestUtils.touch(this.fs, filePath);
        paths.add(filePath);
        this.pageSizePreconditionForTest(paths.size());
        AbstractContractBulkDeleteTest.assertSuccessfulBulkDelete(WrappedIO.bulkDelete_delete((FileSystem)this.getFileSystem(), (Path)this.basePath, paths));
    }

    public static void assertSuccessfulBulkDelete(List<Map.Entry<Path, String>> entries) {
        ((ListAssert)Assertions.assertThat(entries).describedAs("Bulk delete failed, return entries should be empty after successful delete", new Object[0])).isEmpty();
    }

    private List<Path> createListOfPaths(int count, Path basePath) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (int i = 0; i < count; ++i) {
            Path path = new Path(basePath, "file-" + i);
            paths.add(path);
        }
        return paths;
    }
}

