/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerOverviewInfo;
import org.apache.hadoop.yarn.server.router.webapp.dao.RouterClusterMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouterSchedulerMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(RouterSchedulerMetrics.class);
    private String subCluster = "N/A";
    private String schedulerType = "N/A";
    private String schedulingResourceType = "N/A";
    private String minimumAllocation = "N/A";
    private String maximumAllocation = "N/A";
    private String applicationPriority = "N/A";
    private String schedulerBusy = "N/A";
    private String rmDispatcherEventQueueSize = "N/A";
    private String schedulerDispatcherEventQueueSize = "N/A";

    public RouterSchedulerMetrics() {
    }

    public RouterSchedulerMetrics(SubClusterInfo subClusterInfo, RouterClusterMetrics metrics, SchedulerOverviewInfo overview) {
        if (subClusterInfo != null) {
            this.initRouterSchedulerMetrics(subClusterInfo.getSubClusterId().getId(), overview);
        }
    }

    public RouterSchedulerMetrics(String localClusterName, SchedulerOverviewInfo overview) {
        this.initRouterSchedulerMetrics(localClusterName, overview);
    }

    private void initRouterSchedulerMetrics(String subClusterName, SchedulerOverviewInfo overview) {
        try {
            this.subCluster = subClusterName;
            this.schedulerType = overview.getSchedulerType();
            this.schedulingResourceType = overview.getSchedulingResourceType();
            this.minimumAllocation = overview.getMinimumAllocation().toString();
            this.maximumAllocation = overview.getMaximumAllocation().toString();
            this.applicationPriority = String.valueOf(overview.getApplicationPriority());
            if (overview.getSchedulerBusy() != -1) {
                this.schedulerBusy = String.valueOf(overview.getSchedulerBusy());
            }
            this.rmDispatcherEventQueueSize = String.valueOf(overview.getRmDispatcherEventQueueSize());
            this.schedulerDispatcherEventQueueSize = String.valueOf(overview.getSchedulerDispatcherEventQueueSize());
        }
        catch (Exception ex) {
            LOG.error("RouterSchedulerMetrics Error.", (Throwable)ex);
        }
    }

    public String getSubCluster() {
        return this.subCluster;
    }

    public String getSchedulerType() {
        return this.schedulerType;
    }

    public String getSchedulingResourceType() {
        return this.schedulingResourceType;
    }

    public String getMinimumAllocation() {
        return this.minimumAllocation;
    }

    public String getMaximumAllocation() {
        return this.maximumAllocation;
    }

    public String getApplicationPriority() {
        return this.applicationPriority;
    }

    public String getRmDispatcherEventQueueSize() {
        return this.rmDispatcherEventQueueSize;
    }

    public String getSchedulerDispatcherEventQueueSize() {
        return this.schedulerDispatcherEventQueueSize;
    }

    public String getSchedulerBusy() {
        return this.schedulerBusy;
    }
}

