/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.ahs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.applicationhistoryservice.NullApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptStartData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationStartData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerStartData;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.WritingApplicationAttemptFinishEvent;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.WritingApplicationAttemptStartEvent;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.WritingApplicationFinishEvent;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.WritingApplicationHistoryEvent;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.WritingApplicationStartEvent;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.WritingContainerFinishEvent;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.WritingContainerStartEvent;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.WritingHistoryEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMApplicationHistoryWriter
extends CompositeService {
    public static final Logger LOG = LoggerFactory.getLogger(RMApplicationHistoryWriter.class);
    private Dispatcher dispatcher;
    @VisibleForTesting
    ApplicationHistoryWriter writer;
    @VisibleForTesting
    boolean historyServiceEnabled;

    public RMApplicationHistoryWriter() {
        super(RMApplicationHistoryWriter.class.getName());
    }

    protected synchronized void serviceInit(Configuration conf) throws Exception {
        this.historyServiceEnabled = conf.getBoolean("yarn.timeline-service.generic-application-history.enabled", false);
        if (conf.get("yarn.timeline-service.generic-application-history.store-class") == null || conf.get("yarn.timeline-service.generic-application-history.store-class").length() == 0 || conf.get("yarn.timeline-service.generic-application-history.store-class").equals(NullApplicationHistoryStore.class.getName())) {
            this.historyServiceEnabled = false;
        }
        if (this.historyServiceEnabled) {
            this.writer = this.createApplicationHistoryStore(conf);
            this.addIfService(this.writer);
            this.dispatcher = this.createDispatcher(conf);
            this.dispatcher.register(WritingHistoryEventType.class, (EventHandler)new ForwardingEventHandler());
            this.addIfService(this.dispatcher);
        }
        super.serviceInit(conf);
    }

    protected Dispatcher createDispatcher(Configuration conf) {
        MultiThreadedDispatcher dispatcher = new MultiThreadedDispatcher(conf.getInt("yarn.resourcemanager.history-writer.multi-threaded-dispatcher.pool-size", 10));
        dispatcher.setDrainEventsOnStop();
        return dispatcher;
    }

    protected ApplicationHistoryStore createApplicationHistoryStore(Configuration conf) {
        try {
            Class storeClass = conf.getClass("yarn.timeline-service.generic-application-history.store-class", NullApplicationHistoryStore.class, ApplicationHistoryStore.class);
            return (ApplicationHistoryStore)storeClass.newInstance();
        }
        catch (Exception e) {
            String msg = "Could not instantiate ApplicationHistoryWriter: " + conf.get("yarn.timeline-service.generic-application-history.store-class", NullApplicationHistoryStore.class.getName());
            LOG.error(msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
    }

    protected void handleWritingApplicationHistoryEvent(WritingApplicationHistoryEvent event) {
        switch ((WritingHistoryEventType)event.getType()) {
            case APP_START: {
                WritingApplicationStartEvent wasEvent = (WritingApplicationStartEvent)event;
                try {
                    this.writer.applicationStarted(wasEvent.getApplicationStartData());
                    LOG.info("Stored the start data of application " + wasEvent.getApplicationId());
                }
                catch (IOException e) {
                    LOG.error("Error when storing the start data of application " + wasEvent.getApplicationId());
                }
                break;
            }
            case APP_FINISH: {
                WritingApplicationFinishEvent wafEvent = (WritingApplicationFinishEvent)event;
                try {
                    this.writer.applicationFinished(wafEvent.getApplicationFinishData());
                    LOG.info("Stored the finish data of application " + wafEvent.getApplicationId());
                }
                catch (IOException e) {
                    LOG.error("Error when storing the finish data of application " + wafEvent.getApplicationId());
                }
                break;
            }
            case APP_ATTEMPT_START: {
                WritingApplicationAttemptStartEvent waasEvent = (WritingApplicationAttemptStartEvent)event;
                try {
                    this.writer.applicationAttemptStarted(waasEvent.getApplicationAttemptStartData());
                    LOG.info("Stored the start data of application attempt " + waasEvent.getApplicationAttemptId());
                }
                catch (IOException e) {
                    LOG.error("Error when storing the start data of application attempt " + waasEvent.getApplicationAttemptId());
                }
                break;
            }
            case APP_ATTEMPT_FINISH: {
                WritingApplicationAttemptFinishEvent waafEvent = (WritingApplicationAttemptFinishEvent)event;
                try {
                    this.writer.applicationAttemptFinished(waafEvent.getApplicationAttemptFinishData());
                    LOG.info("Stored the finish data of application attempt " + waafEvent.getApplicationAttemptId());
                }
                catch (IOException e) {
                    LOG.error("Error when storing the finish data of application attempt " + waafEvent.getApplicationAttemptId());
                }
                break;
            }
            case CONTAINER_START: {
                WritingContainerStartEvent wcsEvent = (WritingContainerStartEvent)event;
                try {
                    this.writer.containerStarted(wcsEvent.getContainerStartData());
                    LOG.info("Stored the start data of container " + wcsEvent.getContainerId());
                }
                catch (IOException e) {
                    LOG.error("Error when storing the start data of container " + wcsEvent.getContainerId());
                }
                break;
            }
            case CONTAINER_FINISH: {
                WritingContainerFinishEvent wcfEvent = (WritingContainerFinishEvent)event;
                try {
                    this.writer.containerFinished(wcfEvent.getContainerFinishData());
                    LOG.info("Stored the finish data of container " + wcfEvent.getContainerId());
                }
                catch (IOException e) {
                    LOG.error("Error when storing the finish data of container " + wcfEvent.getContainerId());
                }
                break;
            }
            default: {
                LOG.error("Unknown WritingApplicationHistoryEvent type: " + event.getType());
            }
        }
    }

    public void applicationStarted(RMApp app) {
        if (this.historyServiceEnabled) {
            this.dispatcher.getEventHandler().handle((Event)new WritingApplicationStartEvent(app.getApplicationId(), ApplicationStartData.newInstance(app.getApplicationId(), app.getName(), app.getApplicationType(), app.getQueue(), app.getUser(), app.getSubmitTime(), app.getStartTime())));
        }
    }

    public void applicationFinished(RMApp app, RMAppState finalState) {
        if (this.historyServiceEnabled) {
            this.dispatcher.getEventHandler().handle((Event)new WritingApplicationFinishEvent(app.getApplicationId(), ApplicationFinishData.newInstance(app.getApplicationId(), app.getFinishTime(), app.getDiagnostics().toString(), app.getFinalApplicationStatus(), RMServerUtils.createApplicationState(finalState))));
        }
    }

    public void applicationAttemptStarted(RMAppAttempt appAttempt) {
        if (this.historyServiceEnabled) {
            this.dispatcher.getEventHandler().handle((Event)new WritingApplicationAttemptStartEvent(appAttempt.getAppAttemptId(), ApplicationAttemptStartData.newInstance(appAttempt.getAppAttemptId(), appAttempt.getHost(), appAttempt.getRpcPort(), appAttempt.getMasterContainer().getId())));
        }
    }

    public void applicationAttemptFinished(RMAppAttempt appAttempt, RMAppAttemptState finalState) {
        if (this.historyServiceEnabled) {
            this.dispatcher.getEventHandler().handle((Event)new WritingApplicationAttemptFinishEvent(appAttempt.getAppAttemptId(), ApplicationAttemptFinishData.newInstance(appAttempt.getAppAttemptId(), appAttempt.getDiagnostics().toString(), appAttempt.getTrackingUrl(), appAttempt.getFinalApplicationStatus(), RMServerUtils.createApplicationAttemptState(finalState))));
        }
    }

    public void containerStarted(RMContainer container) {
        if (this.historyServiceEnabled) {
            this.dispatcher.getEventHandler().handle((Event)new WritingContainerStartEvent(container.getContainerId(), ContainerStartData.newInstance(container.getContainerId(), container.getAllocatedResource(), container.getAllocatedNode(), container.getAllocatedPriority(), container.getCreationTime())));
        }
    }

    public void containerFinished(RMContainer container) {
        if (this.historyServiceEnabled) {
            this.dispatcher.getEventHandler().handle((Event)new WritingContainerFinishEvent(container.getContainerId(), ContainerFinishData.newInstance(container.getContainerId(), container.getFinishTime(), container.getDiagnosticsInfo(), container.getContainerExitStatus(), container.getContainerState())));
        }
    }

    protected static class MultiThreadedDispatcher
    extends CompositeService
    implements Dispatcher {
        private List<AsyncDispatcher> dispatchers = new ArrayList<AsyncDispatcher>();

        public MultiThreadedDispatcher(int num) {
            super(MultiThreadedDispatcher.class.getName());
            for (int i = 0; i < num; ++i) {
                AsyncDispatcher dispatcher = this.createDispatcher();
                this.dispatchers.add(dispatcher);
                this.addIfService(dispatcher);
            }
        }

        public EventHandler<Event> getEventHandler() {
            return new CompositEventHandler();
        }

        public void register(Class<? extends Enum> eventType, EventHandler handler) {
            for (AsyncDispatcher dispatcher : this.dispatchers) {
                dispatcher.register(eventType, handler);
            }
        }

        public void setDrainEventsOnStop() {
            for (AsyncDispatcher dispatcher : this.dispatchers) {
                dispatcher.setDrainEventsOnStop();
            }
        }

        protected AsyncDispatcher createDispatcher() {
            return new AsyncDispatcher("RM ApplicationHistory dispatcher");
        }

        private class CompositEventHandler
        implements EventHandler<Event> {
            private CompositEventHandler() {
            }

            public void handle(Event event) {
                int index = (event.hashCode() & Integer.MAX_VALUE) % MultiThreadedDispatcher.this.dispatchers.size();
                ((AsyncDispatcher)MultiThreadedDispatcher.this.dispatchers.get(index)).getEventHandler().handle(event);
            }
        }
    }

    private final class ForwardingEventHandler
    implements EventHandler<WritingApplicationHistoryEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(WritingApplicationHistoryEvent event) {
            RMApplicationHistoryWriter.this.handleWritingApplicationHistoryEvent(event);
        }
    }
}

