/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.HashMap;
import org.ojalgo.access.Access1D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.finance.portfolio.LowerUpper;
import org.ojalgo.finance.portfolio.MarketEquilibrium;
import org.ojalgo.finance.portfolio.OptimisedPortfolio;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class MarkowitzModel
extends OptimisedPortfolio {
    private static final double _0_0 = BigMath.ZERO.doubleValue();
    private static final double INIT = PrimitiveFunction.SQRT.invoke(PrimitiveMath.TEN);
    private static final double MAX = PrimitiveMath.HUNDRED * PrimitiveMath.HUNDRED;
    private static final double MIN = PrimitiveMath.HUNDREDTH;
    private static final NumberContext TARGET_CONTEXT = NumberContext.getGeneral(7, 14);
    private final HashMap<int[], LowerUpper> myConstraints = new HashMap();
    private transient ExpressionsBasedModel myOptimisationModel;
    private BigDecimal myTargetReturn;
    private BigDecimal myTargetVariance;

    public MarkowitzModel(BasicMatrix covarianceMatrix, BasicMatrix expectedExcessReturns) {
        super(covarianceMatrix, expectedExcessReturns);
    }

    public MarkowitzModel(FinancePortfolio.Context portfolioContext) {
        super(portfolioContext);
    }

    public MarkowitzModel(MarketEquilibrium marketEquilibrium, BasicMatrix expectedExcessReturns) {
        super(marketEquilibrium, expectedExcessReturns);
    }

    public LowerUpper addConstraint(BigDecimal lowerLimit, BigDecimal upperLimit, int ... assetIndeces) {
        return this.myConstraints.put(assetIndeces, new LowerUpper(lowerLimit, upperLimit));
    }

    public final void clearAllConstraints() {
        this.myConstraints.clear();
        this.reset();
    }

    public final void setLowerLimit(int assetIndex, BigDecimal lowerLimit) {
        this.getVariable(assetIndex).lower(lowerLimit);
        this.reset();
    }

    public final void setTargetReturn(BigDecimal targetReturn) {
        this.myTargetReturn = targetReturn;
        this.myTargetVariance = null;
        this.reset();
    }

    public final void setTargetVariance(BigDecimal targetVariance) {
        this.myTargetVariance = targetVariance;
        this.myTargetReturn = null;
        this.reset();
    }

    public final void setUpperLimit(int assetIndex, BigDecimal upperLimit) {
        this.getVariable(assetIndex).upper(upperLimit);
        this.reset();
    }

    @Override
    public String toString() {
        if (this.myOptimisationModel == null) {
            this.calculateAssetWeights();
        }
        return this.myOptimisationModel.toString();
    }

    private ExpressionsBasedModel generateOptimisationModel(double riskAversion) {
        if (this.myOptimisationModel == null) {
            this.myOptimisationModel = this.makeModel(this.myConstraints);
        }
        this.myOptimisationModel.getExpression("Variance").weight(riskAversion / 2.0);
        return this.myOptimisationModel;
    }

    @Override
    protected BasicMatrix calculateAssetWeights() {
        Optimisation.Result tmpResult;
        if (this.getOptimisationOptions().debug_appender != null) {
            BasicLogger.debug();
            BasicLogger.debug("###################################################");
            BasicLogger.debug("BEGIN RAF: {} MarkowitzModel optimisation", this.getRiskAversion());
            BasicLogger.debug("###################################################");
            BasicLogger.debug();
        }
        if (this.myTargetReturn != null || this.myTargetVariance != null) {
            double tmpTargetValue = this.myTargetVariance != null ? this.myTargetVariance.doubleValue() : (this.myTargetReturn != null ? this.myTargetReturn.doubleValue() : _0_0);
            tmpResult = this.generateOptimisationModel(_0_0).minimise();
            double tmpTargetNow = _0_0;
            double tmpTargetDiff = _0_0;
            double tmpTargetLast = _0_0;
            if (tmpResult.getState().isFeasible()) {
                double tmpHigh;
                double tmpLow;
                double tmpCurrent;
                if (this.isDefaultRiskAversion()) {
                    tmpCurrent = INIT;
                    tmpLow = MAX;
                    tmpHigh = MIN;
                } else {
                    tmpCurrent = this.getRiskAversion().doubleValue();
                    tmpLow = tmpCurrent * INIT;
                    tmpHigh = tmpCurrent / INIT;
                }
                do {
                    tmpResult = this.generateOptimisationModel(tmpCurrent).minimise();
                    tmpTargetLast = tmpTargetNow;
                    tmpTargetNow = this.myTargetVariance != null ? this.calculatePortfolioVariance(tmpResult).doubleValue() : (this.myTargetReturn != null ? this.calculatePortfolioReturn(tmpResult, this.calculateAssetReturns()).doubleValue() : tmpTargetValue);
                    tmpTargetDiff = tmpTargetNow - tmpTargetValue;
                    if (tmpTargetDiff < _0_0) {
                        tmpLow = tmpCurrent;
                    } else if (tmpTargetDiff > _0_0) {
                        tmpHigh = tmpCurrent;
                    }
                    tmpCurrent = PrimitiveFunction.SQRT.invoke(tmpLow * tmpHigh);
                    if (this.getOptimisationOptions().debug_appender == null) continue;
                    BasicLogger.debug();
                    BasicLogger.debug("RAF:   {}", tmpCurrent);
                    BasicLogger.debug("Last: {}", tmpTargetLast);
                    BasicLogger.debug("Now: {}", tmpTargetNow);
                    BasicLogger.debug("Target: {}", tmpTargetValue);
                    BasicLogger.debug("Diff:   {}", tmpTargetDiff);
                } while (!TARGET_CONTEXT.isSmall(tmpTargetValue, tmpTargetDiff) && TARGET_CONTEXT.isDifferent(tmpTargetLast, tmpTargetNow));
            }
        } else {
            tmpResult = this.generateOptimisationModel(this.getRiskAversion().doubleValue()).minimise();
        }
        return this.handle(tmpResult);
    }

    @Override
    protected void reset() {
        super.reset();
        this.myOptimisationModel = null;
    }

    final Scalar<?> calculatePortfolioReturn(Access1D<?> weightsVctr, BasicMatrix returnsVctr) {
        return super.calculatePortfolioReturn((BasicMatrix)MATRIX_FACTORY.columns(weightsVctr), returnsVctr);
    }

    final Scalar<?> calculatePortfolioVariance(Access1D<?> weightsVctr) {
        return super.calculatePortfolioVariance((BasicMatrix)MATRIX_FACTORY.columns(weightsVctr));
    }
}

