/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import org.apache.hadoop.ipc.internal.ShadedProtobufHelper;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.junit.Test;

public class TestShadedProtobufHelper
extends AbstractHadoopTestBase {
    @Test
    public void testExtractRemoteExceptionNoCause() throws Throwable {
        ServiceException source = new ServiceException("empty");
        IOException ex = ShadedProtobufHelper.getRemoteException((ServiceException)source);
        LambdaTestUtils.verifyCause(ServiceException.class, ex);
    }

    @Test
    public void testExtractRemoteExceptionIOECause() throws Throwable {
        IOException source = new IOException("ioe");
        IOException ex = ShadedProtobufHelper.getRemoteException((ServiceException)new ServiceException((Throwable)source));
        if (ex != source) {
            throw ex;
        }
    }

    @Test
    public void testExtractRemoteExceptionOtherCause() throws Throwable {
        NullPointerException source = new NullPointerException("npe");
        IOException ex = ShadedProtobufHelper.getRemoteException((ServiceException)new ServiceException((Throwable)source));
        ServiceException c1 = LambdaTestUtils.verifyCause(ServiceException.class, ex);
        LambdaTestUtils.verifyCause(NullPointerException.class, (Throwable)c1);
    }

    @Test
    public void testIPCWrapperServiceException() throws Throwable {
        LambdaTestUtils.intercept(IOException.class, "expected", () -> ShadedProtobufHelper.ipc(() -> {
            throw new ServiceException("expected");
        }));
    }

    @Test
    public void testIPCWrapperNPE() throws Throwable {
        IOException ex = LambdaTestUtils.intercept(IOException.class, "npe", () -> ShadedProtobufHelper.ipc(() -> {
            throw new ServiceException((Throwable)new NullPointerException("npe"));
        }));
        ServiceException c1 = LambdaTestUtils.verifyCause(ServiceException.class, ex);
        LambdaTestUtils.verifyCause(NullPointerException.class, (Throwable)c1);
    }
}

