/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.util;

import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class StringUtils {
    private StringUtils() {
    }

    public static String humanTimeDiff(long timeDiff) {
        if (timeDiff < 1000L) {
            return String.format("%d msec", timeDiff);
        }
        StringBuilder buf = new StringBuilder();
        long hours = timeDiff / 3600000L;
        long rem = timeDiff % 3600000L;
        long minutes = rem / 60000L;
        float seconds = (float)(rem %= 60000L) / 1000.0f;
        if (hours != 0L) {
            buf.append(hours);
            buf.append(" hrs, ");
        }
        if (minutes != 0L) {
            buf.append(minutes);
            buf.append(" mins, ");
        }
        if (hours > 0L || minutes > 0L) {
            buf.append(seconds);
            buf.append(" sec");
        } else {
            buf.append(String.format("%.4f sec", Float.valueOf(seconds)));
        }
        return buf.toString();
    }

    public static String humanSize(double size) {
        if (size >= 1.099511627776E12) {
            return String.format("%.1f T", size / 1.099511627776E12);
        }
        if (size >= 1.073741824E9) {
            return String.format("%.1f G", size / 1.073741824E9);
        }
        if (size >= 1048576.0) {
            return String.format("%.1f M", size / 1048576.0);
        }
        if (size >= 1024.0) {
            return String.format("%.1f K", size / 1024.0);
        }
        return String.format("%.0f", size);
    }

    public static boolean isEmpty(String input) {
        return input == null || input.length() == 0;
    }

    public static String buildString(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    public static StringBuilder appendStrings(StringBuilder sb, String ... parts) {
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
        }
        return sb;
    }
}

