/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.quotas.RegionSize;
import org.apache.hadoop.hbase.quotas.RegionSizeImpl;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionSizeStoreImpl
implements RegionSizeStore {
    private static final Logger LOG = LoggerFactory.getLogger(RegionSizeStoreImpl.class);
    private static final long sizeOfEntry = ClassSize.align((int)(ClassSize.CONCURRENT_HASHMAP_ENTRY + ClassSize.OBJECT + 8 + ClassSize.OBJECT + 100));
    private final ConcurrentHashMap<RegionInfo, RegionSize> store = new ConcurrentHashMap();

    @Override
    public Iterator<Map.Entry<RegionInfo, RegionSize>> iterator() {
        return this.store.entrySet().iterator();
    }

    @Override
    public RegionSize getRegionSize(RegionInfo regionInfo) {
        return this.store.get(regionInfo);
    }

    @Override
    public void put(RegionInfo regionInfo, long size) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Setting space quota size for " + regionInfo + " to " + size);
        }
        this.store.compute(regionInfo, (key, value) -> value == null ? new RegionSizeImpl(size) : value.setSize(size));
    }

    @Override
    public void incrementRegionSize(RegionInfo regionInfo, long delta) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Updating space quota size for " + regionInfo + " with a delta of " + delta);
        }
        this.store.compute(regionInfo, (key, value) -> value == null ? new RegionSizeImpl(delta) : value.incrementSize(delta));
    }

    @Override
    public RegionSize remove(RegionInfo regionInfo) {
        return this.store.remove(regionInfo);
    }

    public long heapSize() {
        return sizeOfEntry * (long)this.store.size();
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public void clear() {
        this.store.clear();
    }
}

