/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.sql;

import java.sql.CallableStatement;
import java.sql.SQLException;

public class FederationSQLOutParameter<T> {
    private final int sqlType;
    private final Class<T> javaType;
    private T value = null;
    private String paramName;

    public FederationSQLOutParameter(String paramName, int sqlType, Class<T> javaType) {
        this.paramName = paramName;
        this.sqlType = sqlType;
        this.javaType = javaType;
    }

    public FederationSQLOutParameter(int sqlType, Class<T> javaType, T value) {
        this.sqlType = sqlType;
        this.javaType = javaType;
        this.value = value;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    void setValue(CallableStatement stmt, int index) throws SQLException {
        Object object = stmt.getObject(index);
        this.value = this.javaType.cast(object);
    }

    void register(CallableStatement stmt, int index) throws SQLException {
        stmt.registerOutParameter(index, this.sqlType);
        if (this.value != null) {
            stmt.setObject(index, this.value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OutParameter: [").append("SqlType: ").append(this.sqlType).append(", ").append("JavaType: ").append(this.javaType).append(", ").append("Value: ").append(this.value).append("]");
        return sb.toString();
    }
}

