/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeDescriptor {
    @Test
    public void testGetInvalidateBlocks() throws Exception {
        int MAX_BLOCKS = 10;
        int REMAINING_BLOCKS = 2;
        int MAX_LIMIT = 8;
        DatanodeDescriptor dd = DFSTestUtil.getLocalDatanodeDescriptor();
        ArrayList<Block> blockList = new ArrayList<Block>(10);
        for (int i = 0; i < 10; ++i) {
            blockList.add(new Block((long)i, 0L, 1000L));
        }
        dd.addBlocksToBeInvalidated(blockList);
        Block[] bc = dd.getInvalidateBlocks(8);
        Assert.assertEquals((long)bc.length, (long)8L);
        bc = dd.getInvalidateBlocks(8);
        Assert.assertEquals((long)bc.length, (long)2L);
    }

    @Test
    public void testBlocksCounter() throws Exception {
        DatanodeDescriptor dd = BlockManagerTestUtil.getLocalDatanodeDescriptor(true);
        Assert.assertEquals((long)0L, (long)dd.numBlocks());
        BlockInfoContiguous blk = new BlockInfoContiguous(new Block(1L), 1);
        BlockInfoContiguous blk1 = new BlockInfoContiguous(new Block(2L), 2);
        DatanodeStorageInfo[] storages = dd.getStorageInfos();
        Assert.assertTrue((storages.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)DatanodeStorageInfo.AddBlockResult.ADDED, (Object)storages[0].addBlock((BlockInfo)blk));
        Assert.assertEquals((long)1L, (long)dd.numBlocks());
        Assert.assertFalse((boolean)BlocksMap.removeBlock((DatanodeDescriptor)dd, (BlockInfo)blk1));
        Assert.assertEquals((long)1L, (long)dd.numBlocks());
        Assert.assertNotEquals((Object)DatanodeStorageInfo.AddBlockResult.ADDED, (Object)storages[0].addBlock((BlockInfo)blk));
        Assert.assertEquals((long)1L, (long)dd.numBlocks());
        Assert.assertEquals((Object)DatanodeStorageInfo.AddBlockResult.ADDED, (Object)storages[0].addBlock((BlockInfo)blk1));
        Assert.assertEquals((long)2L, (long)dd.numBlocks());
        Assert.assertTrue((boolean)BlocksMap.removeBlock((DatanodeDescriptor)dd, (BlockInfo)blk));
        Assert.assertEquals((long)1L, (long)dd.numBlocks());
        Assert.assertTrue((boolean)BlocksMap.removeBlock((DatanodeDescriptor)dd, (BlockInfo)blk1));
        Assert.assertEquals((long)0L, (long)dd.numBlocks());
    }
}

