/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGetContentSummaryWithPermission {
    protected static final short REPLICATION = 3;
    protected static final long BLOCKSIZE = 1024L;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testGetContentSummarySuperUser() throws Exception {
        Path foo = new Path("/fooSuper");
        Path bar = new Path(foo, "barSuper");
        Path baz = new Path(bar, "bazSuper");
        this.dfs.mkdirs(bar);
        DFSTestUtil.createFile((FileSystem)this.dfs, baz, 10L, (short)3, 0L);
        ContentSummary summary = this.cluster.getNameNodeRpc().getContentSummary(foo.toString());
        this.verifySummary(summary, 2, 1, 10);
        this.dfs.setPermission(foo, new FsPermission(0));
        summary = this.cluster.getNameNodeRpc().getContentSummary(foo.toString());
        this.verifySummary(summary, 2, 1, 10);
        this.dfs.setPermission(bar, new FsPermission(0));
        summary = this.cluster.getNameNodeRpc().getContentSummary(foo.toString());
        this.verifySummary(summary, 2, 1, 10);
        this.dfs.setPermission(baz, new FsPermission(0));
        summary = this.cluster.getNameNodeRpc().getContentSummary(foo.toString());
        this.verifySummary(summary, 2, 1, 10);
    }

    @Test
    public void testGetContentSummaryNonSuperUser() throws Exception {
        Path foo = new Path("/fooNoneSuper");
        Path bar = new Path(foo, "barNoneSuper");
        Path baz = new Path(bar, "bazNoneSuper");
        UserGroupInformation userUgi = UserGroupInformation.createUserForTesting((String)"randomUser", (String[])new String[]{"randomGroup"});
        this.dfs.mkdirs(bar);
        DFSTestUtil.createFile((FileSystem)this.dfs, baz, 10L, (short)3, 0L);
        FileStatus fileStatus = this.dfs.getFileStatus(foo);
        Assert.assertEquals((long)755L, (long)fileStatus.getPermission().toOctal());
        fileStatus = this.dfs.getFileStatus(bar);
        Assert.assertEquals((long)755L, (long)fileStatus.getPermission().toOctal());
        fileStatus = this.dfs.getFileStatus(baz);
        Assert.assertEquals((long)644L, (long)fileStatus.getPermission().toOctal());
        ContentSummary summary = (ContentSummary)userUgi.doAs(() -> this.cluster.getNameNodeRpc().getContentSummary(foo.toString()));
        this.verifySummary(summary, 2, 1, 10);
        this.dfs.setPermission(foo, new FsPermission(0));
        try {
            userUgi.doAs(() -> this.cluster.getNameNodeRpc().getContentSummary(foo.toString()));
            Assert.fail((String)"Should've fail due to access control exception.");
        }
        catch (AccessControlException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Permission denied"));
        }
        this.dfs.setPermission(foo, new FsPermission(FsAction.READ_EXECUTE, FsAction.READ_EXECUTE, FsAction.READ_EXECUTE));
        this.dfs.setPermission(bar, new FsPermission(0));
        try {
            userUgi.doAs(() -> this.cluster.getNameNodeRpc().getContentSummary(foo.toString()));
            Assert.fail((String)"Should've fail due to access control exception.");
        }
        catch (AccessControlException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Permission denied"));
        }
        this.dfs.setPermission(bar, new FsPermission(FsAction.READ_EXECUTE, FsAction.READ_EXECUTE, FsAction.READ_EXECUTE));
        summary = (ContentSummary)userUgi.doAs(() -> this.cluster.getNameNodeRpc().getContentSummary(foo.toString()));
        this.verifySummary(summary, 2, 1, 10);
        this.dfs.setPermission(baz, new FsPermission(0));
        summary = (ContentSummary)userUgi.doAs(() -> this.cluster.getNameNodeRpc().getContentSummary(foo.toString()));
        this.verifySummary(summary, 2, 1, 10);
    }

    private void verifySummary(ContentSummary summary, int dirCount, int fileCount, int length) {
        Assert.assertEquals((long)dirCount, (long)summary.getDirectoryCount());
        Assert.assertEquals((long)fileCount, (long)summary.getFileCount());
        Assert.assertEquals((long)length, (long)summary.getLength());
    }
}

