/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.testing;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testing.TestingHBaseClusterImpl;
import org.apache.hadoop.hbase.testing.TestingHBaseClusterOption;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface TestingHBaseCluster {
    public Configuration getConf();

    public void startMaster() throws Exception;

    public void startMaster(String var1, int var2) throws Exception;

    public CompletableFuture<Void> stopMaster(ServerName var1) throws Exception;

    public void startRegionServer() throws Exception;

    public void startRegionServer(String var1, int var2) throws Exception;

    public CompletableFuture<Void> stopRegionServer(ServerName var1) throws Exception;

    public void stopHBaseCluster() throws Exception;

    public void startHBaseCluster() throws Exception;

    public boolean isHBaseClusterRunning();

    public void start() throws Exception;

    public Optional<ServerName> getActiveMasterAddress();

    public List<ServerName> getBackupMasterAddresses();

    public List<ServerName> getRegionServerAddresses();

    @InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
    public Optional<Region> getRegion(RegionInfo var1);

    @InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
    public Optional<OnlineRegions> getOnlineRegionsInterface(ServerName var1);

    public boolean isClusterRunning();

    public void stop() throws Exception;

    public static TestingHBaseCluster create(TestingHBaseClusterOption option) {
        return new TestingHBaseClusterImpl(option);
    }
}

