/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import org.apache.hadoop.hbase.chaos.actions.UnbalanceKillAndRebalanceAction;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.PeriodicRandomActionPolicy;

public class UnbalanceMonkeyFactory
extends MonkeyFactory {
    private long chaosEveryMilliSec;
    private long waitForUnbalanceMilliSec;
    private long waitForKillMilliSec;
    private long waitAfterBalanceMilliSec;
    private boolean killMetaRs;

    @Override
    public ChaosMonkey build() {
        this.loadProperties();
        PeriodicRandomActionPolicy chaosPolicy = new PeriodicRandomActionPolicy(this.chaosEveryMilliSec, new UnbalanceKillAndRebalanceAction(this.waitForUnbalanceMilliSec, this.waitForKillMilliSec, this.waitAfterBalanceMilliSec, this.killMetaRs));
        return new PolicyBasedChaosMonkey(this.properties, this.util, chaosPolicy);
    }

    private void loadProperties() {
        this.chaosEveryMilliSec = Long.parseLong(this.properties.getProperty("unbalance.chaos.period", "65000"));
        this.waitForUnbalanceMilliSec = Long.parseLong(this.properties.getProperty("unbalance.action.wait.period", "2000"));
        this.waitForKillMilliSec = Long.parseLong(this.properties.getProperty("unbalance.action.kill.period", "2000"));
        this.waitAfterBalanceMilliSec = Long.parseLong(this.properties.getProperty("unbalance.action.wait.after.period", "5000"));
        this.killMetaRs = Boolean.parseBoolean(this.properties.getProperty("unbalance.action.kill.meta.rs", "true"));
    }
}

