/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParseException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParserForCompareExpr;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValueFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class TimelineParserForKVFilters
extends TimelineParserForCompareExpr {
    private final boolean valueAsString;

    public TimelineParserForKVFilters(String expression, boolean valAsStr) {
        super(expression, "Config/Info Filter");
        this.valueAsString = valAsStr;
    }

    @Override
    protected TimelineFilter createFilter() {
        return new TimelineKeyValueFilter();
    }

    @Override
    protected Object parseValue(String strValue) {
        if (!this.valueAsString) {
            try {
                return GenericObjectMapper.OBJECT_READER.readValue(strValue);
            }
            catch (IOException e) {
                return strValue;
            }
        }
        return strValue;
    }

    @Override
    protected void setCompareOpToCurrentFilter(TimelineCompareOp compareOp, boolean keyMustExistFlag) throws TimelineParseException {
        if (compareOp != TimelineCompareOp.EQUAL && compareOp != TimelineCompareOp.NOT_EQUAL) {
            throw new TimelineParseException("TimelineCompareOp for kv-filter should be EQUAL or NOT_EQUAL");
        }
        ((TimelineKeyValueFilter)this.getCurrentFilter()).setCompareOp(compareOp, keyMustExistFlag);
    }

    @Override
    protected void setValueToCurrentFilter(Object value) {
        TimelineFilter currentFilter = this.getCurrentFilter();
        if (currentFilter != null) {
            ((TimelineKeyValueFilter)currentFilter).setValue(value);
        }
    }
}

