/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hadoop.hbase.io.hfile.bucket.FileIOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.TestByteBufferIOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.RefCnt;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={IOTests.class, SmallTests.class})
public class TestFileIOEngine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE;
    private static final long TOTAL_CAPACITY = 0x600000L;
    private static final String[] FILE_PATHS;
    private static final long SIZE_PER_FILE;
    private static final List<Long> boundaryStartPositions;
    private static final List<Long> boundaryStopPositions;
    private FileIOEngine fileIOEngine;

    @Before
    public void setUp() throws IOException {
        this.fileIOEngine = new FileIOEngine(0x600000L, false, FILE_PATHS);
    }

    @After
    public void cleanUp() {
        this.fileIOEngine.shutdown();
        for (String filePath : FILE_PATHS) {
            File file = new File(filePath);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    @Test
    public void testFileIOEngine() throws IOException {
        for (int i = 0; i < 500; ++i) {
            int len = (int)Math.floor(Math.random() * 100.0) + 1;
            long offset = (long)Math.floor(Math.random() * 6291456.0 % (double)(0x600000L - (long)len));
            if (i < boundaryStartPositions.size()) {
                offset = boundaryStartPositions.get(i);
            } else if (i - boundaryStartPositions.size() < boundaryStopPositions.size()) {
                offset = boundaryStopPositions.get(i - boundaryStartPositions.size()) - (long)len + 1L;
            } else if (i % 2 == 0) {
                offset = (long)Math.max(1, i % FILE_PATHS.length) * SIZE_PER_FILE - (long)(len / 2);
            }
            byte[] data1 = new byte[len];
            for (int j = 0; j < data1.length; ++j) {
                data1[j] = (byte)(Math.random() * 255.0);
            }
            this.fileIOEngine.write(ByteBuffer.wrap(data1), offset);
            BucketEntry be = TestByteBufferIOEngine.createBucketEntry(offset, len);
            this.fileIOEngine.read(be);
            ByteBuff data2 = TestByteBufferIOEngine.getByteBuff(be);
            Assert.assertArrayEquals((byte[])data1, (byte[])data2.array());
        }
    }

    @Test
    public void testFileIOEngineHandlesZeroLengthInput() throws IOException {
        byte[] data1 = new byte[]{};
        this.fileIOEngine.write(ByteBuffer.wrap(data1), 0L);
        BucketEntry be = TestByteBufferIOEngine.createBucketEntry(0L, 0);
        this.fileIOEngine.read(be);
        ByteBuff data2 = TestByteBufferIOEngine.getByteBuff(be);
        Assert.assertArrayEquals((byte[])data1, (byte[])data2.array());
    }

    @Test
    public void testReadFailedShouldReleaseByteBuff() {
        ByteBuffAllocator alloc = (ByteBuffAllocator)Mockito.mock(ByteBuffAllocator.class);
        final RefCnt refCnt = RefCnt.create();
        Mockito.when((Object)alloc.allocate(Mockito.anyInt())).thenAnswer((Answer)new Answer<ByteBuff>(){

            public ByteBuff answer(InvocationOnMock invocation) throws Throwable {
                int len = (Integer)invocation.getArgument(0);
                return ByteBuff.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.allocate(len + 1)}, (RefCnt)refCnt);
            }
        });
        int len = 10;
        byte[] data1 = new byte[len];
        Assert.assertEquals((long)1L, (long)refCnt.refCnt());
        try {
            this.fileIOEngine.write(ByteBuffer.wrap(data1), 0L);
            BucketEntry be = TestByteBufferIOEngine.createBucketEntry(0L, len, alloc);
            this.fileIOEngine.read(be);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)refCnt.refCnt());
    }

    @Test
    public void testClosedChannelException() throws IOException {
        this.fileIOEngine.closeFileChannels();
        int len = 5;
        long offset = 0L;
        int val = (int)(Math.random() * 255.0);
        for (int i = 0; i < 2; ++i) {
            ByteBuff src = TestByteBufferIOEngine.createByteBuffer(len, val, i % 2 == 0);
            int pos = src.position();
            int lim = src.limit();
            this.fileIOEngine.write(src, offset);
            src.position(pos).limit(lim);
            BucketEntry be = TestByteBufferIOEngine.createBucketEntry(offset, len);
            this.fileIOEngine.read(be);
            ByteBuff dst = TestByteBufferIOEngine.getByteBuff(be);
            Assert.assertEquals((long)src.remaining(), (long)len);
            Assert.assertEquals((long)dst.remaining(), (long)len);
            Assert.assertEquals((long)0L, (long)ByteBuff.compareTo((ByteBuff)src, (int)pos, (int)len, (ByteBuff)dst, (int)dst.position(), (int)dst.remaining()));
        }
    }

    @Test
    public void testRefreshFileConnection() throws IOException {
        FileChannel[] fileChannels = this.fileIOEngine.getFileChannels();
        FileChannel fileChannel = fileChannels[0];
        Assert.assertNotNull((Object)fileChannel);
        fileChannel.close();
        this.fileIOEngine.refreshFileConnection(0, new IOException("Test Exception"));
        FileChannel[] reopenedFileChannels = this.fileIOEngine.getFileChannels();
        FileChannel reopenedFileChannel = reopenedFileChannels[0];
        Assert.assertNotEquals((Object)fileChannel, (Object)reopenedFileChannel);
        Assert.assertEquals((long)fileChannels.length, (long)reopenedFileChannels.length);
        for (int i = 1; i < fileChannels.length; ++i) {
            Assert.assertEquals((Object)fileChannels[i], (Object)reopenedFileChannels[i]);
        }
    }

    static {
        int i;
        CLASS_RULE = HBaseClassTestRule.forClass(TestFileIOEngine.class);
        FILE_PATHS = new String[]{"testFileIOEngine1", "testFileIOEngine2", "testFileIOEngine3"};
        SIZE_PER_FILE = 0x600000L / (long)FILE_PATHS.length;
        boundaryStartPositions = new ArrayList<Long>();
        boundaryStopPositions = new ArrayList<Long>();
        boundaryStartPositions.add(0L);
        for (i = 1; i < FILE_PATHS.length; ++i) {
            boundaryStartPositions.add(SIZE_PER_FILE * (long)i - 1L);
            boundaryStartPositions.add(SIZE_PER_FILE * (long)i);
            boundaryStartPositions.add(SIZE_PER_FILE * (long)i + 1L);
        }
        for (i = 1; i < FILE_PATHS.length; ++i) {
            boundaryStopPositions.add(SIZE_PER_FILE * (long)i - 1L);
            boundaryStopPositions.add(SIZE_PER_FILE * (long)i);
            boundaryStopPositions.add(SIZE_PER_FILE * (long)i + 1L);
        }
        boundaryStopPositions.add(SIZE_PER_FILE * (long)FILE_PATHS.length - 1L);
    }
}

