/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.BlacklistManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;

public interface RMAppAttempt
extends EventHandler<RMAppAttemptEvent> {
    public ApplicationAttemptId getAppAttemptId();

    public RMAppAttemptState getAppAttemptState();

    public String getHost();

    public int getRpcPort();

    public String getTrackingUrl();

    public String getOriginalTrackingUrl();

    public String getWebProxyBase();

    public String getDiagnostics();

    public float getProgress();

    public FinalApplicationStatus getFinalApplicationStatus();

    public List<ContainerStatus> pullJustFinishedContainers();

    public ConcurrentMap<NodeId, List<ContainerStatus>> getJustFinishedContainersReference();

    public List<ContainerStatus> getJustFinishedContainers();

    public ConcurrentMap<NodeId, List<ContainerStatus>> getFinishedContainersSentToAMReference();

    public Container getMasterContainer();

    public ApplicationSubmissionContext getSubmissionContext();

    public Token<AMRMTokenIdentifier> getAMRMToken();

    @InterfaceAudience.LimitedPrivate(value={"RMStateStore"})
    public SecretKey getClientTokenMasterKey();

    public Token<ClientToAMTokenIdentifier> createClientToken(String var1);

    public ApplicationResourceUsageReport getApplicationResourceUsageReport();

    public BlacklistManager getAMBlacklistManager();

    public long getStartTime();

    public RMAppAttemptState getState();

    public RMAppAttemptState getPreviousState();

    public YarnApplicationAttemptState createApplicationAttemptState();

    public ApplicationAttemptReport createApplicationAttemptReport();

    public boolean shouldCountTowardsMaxAttemptRetry();

    public RMAppAttemptMetrics getRMAppAttemptMetrics();

    public long getFinishTime();

    public void updateAMLaunchDiagnostics(String var1);

    public Set<String> getBlacklistedNodes();
}

