/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

public class SchedContainerChangeRequest
implements Comparable<SchedContainerChangeRequest> {
    private RMContext rmContext;
    private RMContainer rmContainer;
    private Resource targetCapacity;
    private SchedulerNode schedulerNode;
    private Resource deltaCapacity;

    public SchedContainerChangeRequest(RMContext rmContext, SchedulerNode schedulerNode, RMContainer rmContainer, Resource targetCapacity) {
        this.rmContext = rmContext;
        this.rmContainer = rmContainer;
        this.targetCapacity = targetCapacity;
        this.schedulerNode = schedulerNode;
    }

    public NodeId getNodeId() {
        return this.rmContainer.getAllocatedNode();
    }

    public RMContainer getRMContainer() {
        return this.rmContainer;
    }

    public Resource getTargetCapacity() {
        return this.targetCapacity;
    }

    public RMContext getRmContext() {
        return this.rmContext;
    }

    public synchronized Resource getDeltaCapacity() {
        if (this.deltaCapacity == null) {
            this.deltaCapacity = Resources.subtract((Resource)this.targetCapacity, (Resource)this.rmContainer.getAllocatedResource());
        }
        return this.deltaCapacity;
    }

    public Priority getPriority() {
        return this.rmContainer.getContainer().getPriority();
    }

    public ContainerId getContainerId() {
        return this.rmContainer.getContainerId();
    }

    public String getNodePartition() {
        return this.schedulerNode.getPartition();
    }

    public SchedulerNode getSchedulerNode() {
        return this.schedulerNode;
    }

    public int hashCode() {
        return (this.getContainerId().hashCode() << 16) + this.targetCapacity.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SchedContainerChangeRequest)) {
            return false;
        }
        return this.compareTo((SchedContainerChangeRequest)other) == 0;
    }

    @Override
    public int compareTo(SchedContainerChangeRequest other) {
        if (other == null) {
            return -1;
        }
        int rc = this.getPriority().compareTo(other.getPriority());
        if (0 != rc) {
            return rc;
        }
        return this.getContainerId().compareTo(other.getContainerId());
    }

    public String toString() {
        return "<container=" + this.getContainerId() + ", targetCapacity=" + this.targetCapacity + ", node=" + this.getNodeId().toString() + ">";
    }
}

