/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementChange;

public class LeafQueueEntitlements {
    private final Map<String, QueueCapacities> entitlements = new HashMap<String, QueueCapacities>();

    public QueueCapacities getCapacityOfQueue(AutoCreatedLeafQueue leafQueue) {
        return this.getCapacityOfQueueByPath(leafQueue.getQueuePath());
    }

    public QueueCapacities getCapacityOfQueueByPath(String leafQueuePath) {
        if (!this.entitlements.containsKey(leafQueuePath)) {
            this.entitlements.put(leafQueuePath, new QueueCapacities(false));
        }
        return this.entitlements.get(leafQueuePath);
    }

    public Map<String, QueueCapacities> getEntitlements() {
        return this.entitlements;
    }

    public List<QueueManagementChange> mapToQueueManagementChanges(BiFunction<String, QueueCapacities, QueueManagementChange> func) {
        return this.entitlements.entrySet().stream().map(e -> (QueueManagementChange)func.apply((String)e.getKey(), (QueueCapacities)e.getValue())).collect(Collectors.toList());
    }
}

