/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.Request;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ZKDatabase;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.Learner;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.Observer;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.ObserverRequestProcessor;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = LoggerFactory.getLogger(ObserverZooKeeperServer.class);
    private boolean syncRequestProcessorEnabled;
    ConcurrentLinkedQueue<Request> pendingSyncs;

    ObserverZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, self.clientPortListenBacklog, zkDb, self);
        this.syncRequestProcessorEnabled = this.self.getSyncEnabled();
        this.pendingSyncs = new ConcurrentLinkedQueue();
        LOG.info("syncEnabled ={}", (Object)this.syncRequestProcessorEnabled);
    }

    public Observer getObserver() {
        return this.self.observer;
    }

    @Override
    public Learner getLearner() {
        return this.self.observer;
    }

    public void commitRequest(Request request) {
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor.processRequest(request);
        }
        this.commitProcessor.commit(request);
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        this.firstProcessor = new ObserverRequestProcessor(this, this.commitProcessor);
        ((ObserverRequestProcessor)this.firstProcessor).start();
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor = new SyncRequestProcessor(this, null);
            this.syncProcessor.start();
        }
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn("Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    @Override
    public String getState() {
        return "observer";
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        super.shutdown();
        if (this.syncRequestProcessorEnabled && this.syncProcessor != null) {
            this.syncProcessor.shutdown();
        }
    }

    @Override
    public void dumpMonitorValues(BiConsumer<String, Object> response) {
        super.dumpMonitorValues(response);
        response.accept("observer_master_id", this.getObserver().getLearnerMasterId());
    }
}

