/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.rules.ImmutableIntersectToSemiJoinRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class IntersectToSemiJoinRule
extends RelRule<Config>
implements TransformationRule {
    protected IntersectToSemiJoinRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Intersect intersect = (Intersect)call.rel(0);
        if (intersect.all) {
            return;
        }
        RelBuilder builder = call.builder();
        RexBuilder rexBuilder = builder.getRexBuilder();
        List<RelNode> inputs = intersect.getInputs();
        if (inputs.size() < 2) {
            return;
        }
        RelDataType leastRowType = intersect.getRowType();
        RelNode current = inputs.get(0);
        builder.push(current);
        for (int i = 1; i < inputs.size(); ++i) {
            RelNode next = inputs.get(i);
            ArrayList<RexNode> conditions = new ArrayList<RexNode>();
            int fieldCount = current.getRowType().getFieldCount();
            for (int j = 0; j < fieldCount; ++j) {
                RelDataType leftFieldType = current.getRowType().getFieldList().get(j).getType();
                RelDataType rightFieldType = next.getRowType().getFieldList().get(j).getType();
                RelDataType leastFieldType = leastRowType.getFieldList().get(j).getType();
                conditions.add(builder.isNotDistinctFrom(rexBuilder.makeCast(leastFieldType, rexBuilder.makeInputRef(leftFieldType, j)), rexBuilder.makeCast(leastFieldType, rexBuilder.makeInputRef(rightFieldType, j + fieldCount))));
            }
            RexNode condition = RexUtil.composeConjunction(rexBuilder, conditions);
            builder.push(next).join(JoinRelType.SEMI, condition);
            current = builder.peek();
        }
        builder.distinct().convert(leastRowType, true);
        call.transformTo(builder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableIntersectToSemiJoinRule.Config.of().withOperandFor(LogicalIntersect.class);

        @Override
        default public IntersectToSemiJoinRule toRule() {
            return new IntersectToSemiJoinRule(this);
        }

        default public Config withOperandFor(Class<? extends Intersect> intersectClass) {
            return this.withOperandSupplier(b -> b.operand(intersectClass).anyInputs()).as(Config.class);
        }
    }
}

