/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.storage.state;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.storage.state.TxStatePartitionStorage;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.worker.ThreadAssertingCursor;
import org.apache.ignite.internal.worker.ThreadAssertions;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingTxStatePartitionStorage
implements TxStatePartitionStorage {
    private final TxStatePartitionStorage storage;

    public ThreadAssertingTxStatePartitionStorage(TxStatePartitionStorage storage) {
        this.storage = storage;
    }

    @Override
    @Nullable
    public TxMeta get(UUID txId) {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.storage.get(txId);
    }

    @Override
    public void putForRebalance(UUID txId, TxMeta txMeta) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.putForRebalance(txId, txMeta);
    }

    @Override
    public boolean compareAndSet(UUID txId, @Nullable TxState txStateExpected, TxMeta txMeta, long commandIndex, long commandTerm) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.storage.compareAndSet(txId, txStateExpected, txMeta, commandIndex, commandTerm);
    }

    @Override
    public void remove(UUID txId, long commandIndex, long commandTerm) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.remove(txId, commandIndex, commandTerm);
    }

    @Override
    public void removeAll(Collection<UUID> txIds, long commandIndex, long commandTerm) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.removeAll(txIds, commandIndex, commandTerm);
    }

    @Override
    public Cursor<IgniteBiTuple<UUID, TxMeta>> scan() {
        ThreadAssertions.assertThreadAllowsTo((ThreadOperation)ThreadOperation.TX_STATE_STORAGE_ACCESS);
        return new ThreadAssertingCursor(this.storage.scan());
    }

    @Override
    public CompletableFuture<Void> flush() {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.storage.flush();
    }

    @Override
    public long lastAppliedIndex() {
        return this.storage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.storage.lastAppliedTerm();
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.lastApplied(lastAppliedIndex, lastAppliedTerm);
    }

    @Override
    public void close() {
        this.storage.close();
    }

    @Override
    public void destroy() {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.destroy();
    }

    @Override
    public CompletableFuture<Void> startRebalance() {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.storage.startRebalance();
    }

    @Override
    public CompletableFuture<Void> abortRebalance() {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.storage.abortRebalance();
    }

    @Override
    public CompletableFuture<Void> finishRebalance(MvPartitionMeta partitionMeta) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.storage.finishRebalance(partitionMeta);
    }

    @Override
    public CompletableFuture<Void> clear() {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.storage.clear();
    }

    @Override
    public void committedGroupConfiguration(byte[] config, long index, long term) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.committedGroupConfiguration(config, index, term);
    }

    @Override
    public byte @Nullable [] committedGroupConfiguration() {
        return this.storage.committedGroupConfiguration();
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        return this.storage.leaseInfo();
    }

    @Override
    public void leaseInfo(LeaseInfo leaseInfo, long index, long term) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.leaseInfo(leaseInfo, index, term);
    }

    @Override
    public byte @Nullable [] snapshotInfo() {
        return this.storage.snapshotInfo();
    }

    @Override
    public void snapshotInfo(byte[] snapshotInfo) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.snapshotInfo(snapshotInfo);
    }
}

