/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.MathUtils;
import java.math.BigInteger;

public class BigIntegerMath {
    private BigIntegerMath() {
    }

    public static byte[] nonnegativeBigIntegerToBigEndianByteArrayForBitSize(BigInteger s, int size) {
        byte[] array;
        int start;
        byte[] b = s.toByteArray();
        Preconditions.checkArgument((b[0] >= 0 ? 1 : 0) != 0, (String)"%s is negative", (Object[])new Object[]{s});
        int n = MathUtils.bitCountToByteCount(size);
        Preconditions.checkArgument((b.length <= n + 1 ? 1 : 0) != 0, (String)"%s has bits that are two high", (Object[])new Object[]{s});
        if (b.length == n + 1) {
            Preconditions.checkArgument((size == n << 3 ? 1 : 0) != 0, (String)"A BigInteger's big endian length of %s cannot be copied into size=%s.", (Object[])new Object[]{b.length, size});
            Preconditions.checkArgument((b[0] == 0 ? 1 : 0) != 0, (Object)"The first byte is a sign bit, and it must be zero.");
            start = 1;
        } else {
            start = 0;
        }
        if (b.length != n) {
            array = new byte[n];
            int len = b.length - start;
            System.arraycopy(b, start, array, n - len, len);
        } else {
            array = b;
        }
        return array;
    }
}

