/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest;

import io.micronaut.context.event.BeanDestroyedEvent;
import io.micronaut.context.event.BeanDestroyedEventListener;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rest.ResourceHolder;

@Singleton
public class ResourceCleaner
implements BeanDestroyedEventListener<ResourceHolder> {
    private static final IgniteLogger LOG = Loggers.forClass(ResourceCleaner.class);

    public void onDestroyed(BeanDestroyedEvent<ResourceHolder> event) {
        ResourceHolder bean = (ResourceHolder)event.getBean();
        if (bean != null) {
            LOG.debug("Cleaning bean {}", new Object[]{bean});
            bean.cleanResources();
        }
    }
}

