/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.schema.AbstractIgniteDataSource;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class IgniteTableImpl
extends AbstractIgniteDataSource
implements IgniteTable {
    private final ImmutableIntList keyColumns;
    @Nullable
    private final ImmutableIntList columnsToInsert;
    @Nullable
    private final ImmutableIntList columnsToUpdate;
    private final Map<String, IgniteIndex> indexMap;
    private final int partitions;
    private final int zoneId;
    private final Lazy<NativeType[]> colocationColumnTypes;

    public IgniteTableImpl(String name, int id, int version, TableDescriptor desc, ImmutableIntList keyColumns, Statistic statistic, Map<String, IgniteIndex> indexMap, int partitions, int zoneId) {
        super(name, id, version, desc, statistic);
        this.keyColumns = keyColumns;
        this.indexMap = indexMap;
        this.partitions = partitions;
        this.zoneId = zoneId;
        this.columnsToInsert = IgniteTableImpl.deriveColumnsToInsert(desc);
        this.columnsToUpdate = IgniteTableImpl.deriveColumnsToUpdate(desc);
        this.colocationColumnTypes = new Lazy(this::evaluateTypes);
    }

    @Nullable
    private static ImmutableIntList deriveColumnsToInsert(TableDescriptor desc) {
        if (!desc.hasHiddenColumns()) {
            return null;
        }
        IntArrayList columnsToInsert = new IntArrayList(desc.columnsCount());
        for (ColumnDescriptor columnDescriptor : desc) {
            if (columnDescriptor.hidden()) continue;
            columnsToInsert.add(columnDescriptor.logicalIndex());
        }
        return ImmutableIntList.of((int[])columnsToInsert.toIntArray());
    }

    @Nullable
    private static ImmutableIntList deriveColumnsToUpdate(TableDescriptor desc) {
        if (!desc.hasVirtualColumns()) {
            return null;
        }
        IntArrayList columnsToUpdate = new IntArrayList(desc.columnsCount());
        for (ColumnDescriptor columnDescriptor : desc) {
            if (columnDescriptor.virtual()) continue;
            columnsToUpdate.add(columnDescriptor.logicalIndex());
        }
        return ImmutableIntList.of((int[])columnsToUpdate.toIntArray());
    }

    @Override
    public Supplier<PartitionCalculator> partitionCalculator() {
        return () -> new PartitionCalculator(this.partitions, Objects.requireNonNull((NativeType[])this.colocationColumnTypes.get()));
    }

    private NativeType[] evaluateTypes() {
        int fieldCnt = this.descriptor().distribution().getKeys().size();
        NativeType[] fieldTypes = new NativeType[fieldCnt];
        int[] colocationColumns = this.descriptor().distribution().getKeys().toIntArray();
        for (int i = 0; i < fieldCnt; ++i) {
            ColumnDescriptor colDesc = this.descriptor().columnDescriptor(colocationColumns[i]);
            fieldTypes[i] = colDesc.physicalType();
        }
        return fieldTypes;
    }

    @Override
    public Map<String, IgniteIndex> indexes() {
        return this.indexMap;
    }

    @Override
    public int partitions() {
        return this.partitions;
    }

    @Override
    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public ImmutableIntList keyColumns() {
        return this.keyColumns;
    }

    @Override
    protected TableScan toRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable relOptTbl, List<RelHint> hints) {
        return IgniteLogicalTableScan.create(cluster, traitSet, hints, relOptTbl, null, null, null, null);
    }

    @Override
    public boolean isUpdateAllowed(int colIdx) {
        ColumnDescriptor columnDescriptor = this.descriptor().columnDescriptor(colIdx);
        return !columnDescriptor.key() && !columnDescriptor.virtual();
    }

    @Override
    public RelDataType rowTypeForInsert(IgniteTypeFactory factory) {
        return this.descriptor().rowType(factory, this.columnsToInsert);
    }

    @Override
    public RelDataType rowTypeForUpdate(IgniteTypeFactory factory) {
        return this.descriptor().rowType(factory, this.columnsToUpdate);
    }

    @Override
    public RelDataType rowTypeForDelete(IgniteTypeFactory factory) {
        return this.descriptor().rowType(factory, this.keyColumns);
    }
}

