/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import org.jetbrains.annotations.Nullable;

public final class EnumOutter {
    private EnumOutter() {
    }

    public static enum ErrorType {
        ERROR_TYPE_NONE(0),
        ERROR_TYPE_LOG(1),
        ERROR_TYPE_STABLE(2),
        ERROR_TYPE_SNAPSHOT(3),
        ERROR_TYPE_STATE_MACHINE(4),
        ERROR_TYPE_META(5);

        private final int value;

        public final int getNumber() {
            return this.value;
        }

        @Deprecated
        public static ErrorType valueOf(int value) {
            return ErrorType.forNumber(value);
        }

        @Nullable
        public static ErrorType forNumber(int value) {
            switch (value) {
                case 0: {
                    return ERROR_TYPE_NONE;
                }
                case 1: {
                    return ERROR_TYPE_LOG;
                }
                case 2: {
                    return ERROR_TYPE_STABLE;
                }
                case 3: {
                    return ERROR_TYPE_SNAPSHOT;
                }
                case 4: {
                    return ERROR_TYPE_STATE_MACHINE;
                }
                case 5: {
                    return ERROR_TYPE_META;
                }
            }
            return null;
        }

        private ErrorType(int value) {
            this.value = value;
        }
    }

    public static enum EntryType {
        ENTRY_TYPE_UNKNOWN(0),
        ENTRY_TYPE_NO_OP(1),
        ENTRY_TYPE_DATA(2),
        ENTRY_TYPE_CONFIGURATION(3);

        private static final EntryType[] VALUES;
        private final int value;

        public final int getNumber() {
            return this.value;
        }

        @Deprecated
        public static EntryType valueOf(int value) {
            return EntryType.forNumber(value);
        }

        @Nullable
        public static EntryType forNumber(int value) {
            switch (value) {
                case 0: {
                    return ENTRY_TYPE_UNKNOWN;
                }
                case 1: {
                    return ENTRY_TYPE_NO_OP;
                }
                case 2: {
                    return ENTRY_TYPE_DATA;
                }
                case 3: {
                    return ENTRY_TYPE_CONFIGURATION;
                }
            }
            return null;
        }

        public static EntryType fromId(int id) throws IllegalArgumentException {
            EntryType entryType = EntryType.forNumber(id);
            if (entryType == null) {
                throw new IllegalArgumentException("No enum constant from id: " + id);
            }
            return entryType;
        }

        public int id() {
            return this.getNumber();
        }

        private EntryType(int value) {
            this.value = value;
        }

        static {
            VALUES = EntryType.values();
        }
    }
}

