/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.marshaller;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite3.internal.partition.replicator.marshaller.PartitionCommandsMarshaller;
import org.apache.ignite3.internal.partition.replicator.marshaller.PartitionCommandsMarshallerImpl;
import org.apache.ignite3.internal.raft.util.DefaultByteBuffersPool;
import org.apache.ignite3.internal.raft.util.OptimizedMarshaller;

public class ThreadLocalPartitionCommandsMarshaller
implements PartitionCommandsMarshaller {
    private final ThreadLocal<PartitionCommandsMarshaller> marshaller;
    private final OptimizedMarshaller.ByteBuffersPool pool = new DefaultByteBuffersPool(Runtime.getRuntime().availableProcessors());

    public ThreadLocalPartitionCommandsMarshaller(MessageSerializationRegistry serializationRegistry) {
        this.marshaller = ThreadLocal.withInitial(() -> new PartitionCommandsMarshallerImpl(serializationRegistry, this.pool));
    }

    @Override
    public byte[] marshall(Object o) {
        return this.marshaller.get().marshall(o);
    }

    @Override
    public <T> T unmarshall(ByteBuffer bytes) {
        return this.marshaller.get().unmarshall(bytes);
    }

    @Override
    public int readRequiredCatalogVersion(ByteBuffer raw) {
        return this.marshaller.get().readRequiredCatalogVersion(raw);
    }

    @Override
    public long readSafeTimestamp(ByteBuffer raw) {
        return this.marshaller.get().readSafeTimestamp(raw);
    }
}

