/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query.func;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.store.query.concurrent.AtomicFloat;
import org.apache.hugegraph.store.query.func.AbstractAggregationFunction;

public abstract class UnaryAggregationFunction<U, T>
extends AbstractAggregationFunction<U, T, T> {
    protected Supplier<U> supplier;
    protected Id field;

    protected UnaryAggregationFunction() {
    }

    public UnaryAggregationFunction(Id field, Supplier<U> supplier) {
        this.field = field;
        this.supplier = supplier;
        this.buffer = this.createBuffer();
    }

    public Id getFieldId() {
        return this.field;
    }

    @Override
    public U createBuffer() {
        return this.initBuffer();
    }

    protected abstract U initBuffer();

    protected U getInitValue(Supplier<AtomicLong> longSupplier, Supplier<AtomicInteger> integerSupplier, Supplier<AtomicDouble> doubleSupplier, Supplier<AtomicFloat> floatSupplier) {
        Number result;
        U ins = this.supplier.get();
        switch (ins.getClass().getName()) {
            case "java.lang.Long": {
                result = longSupplier.get();
                break;
            }
            case "java.lang.Integer": {
                result = integerSupplier.get();
                break;
            }
            case "java.lang.Double": {
                result = doubleSupplier.get();
                break;
            }
            case "java.lang.Float": {
                result = floatSupplier.get();
                break;
            }
            case "java.lang.String": {
                result = null;
                break;
            }
            default: {
                result = (Number)ins;
            }
        }
        return (U)result;
    }
}

