/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.gridkit.jvmtool.agent.HotspotInternalMBeanEnabler;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.cmd.SjkAgentHelper;

public class HsTweakCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "hs";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new HsTweak(host);
    }

    @Parameters(commandDescription="Hotspot JVM tweaks")
    public static class HsTweak
    implements Runnable {
        @Parameter(names={"-p"}, required=true, description="Target JVM PID")
        private long pid;
        @Parameter(names={"--enable-hotspot-mbean"}, required=true, description="Activate Hotspot Internal MBean")
        private boolean enableHotspotMBean = false;
        @ParametersDelegate
        private CommandLauncher host;

        public HsTweak(CommandLauncher host) {
            this.host = host;
        }

        @Override
        public void run() {
            try {
                if (this.host.isVerbose()) {
                    SjkAgentHelper.enableTrace(true);
                }
                if (!this.enableHotspotMBean) {
                    this.host.fail(new String[]{"No option provided. At least one of following options is required:\n  --enable-hotspot-mbean"});
                }
                if (this.enableHotspotMBean) {
                    SjkAgentHelper.agentCommand(this.pid, HotspotInternalMBeanEnabler.class, "", TimeUnit.SECONDS.toMillis(30L));
                }
            }
            catch (IOException e) {
                this.host.fail("", (Exception)e);
            }
        }
    }
}

