/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.fury.Fury;
import org.apache.fury.exception.DeserializationException;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.serializer.BufferCallback;
import org.apache.fury.util.ExceptionUtils;
import org.apache.fury.util.Preconditions;

public class BlockedStreamUtils {
    public static void serialize(Fury fury, OutputStream outputStream, Object obj) {
        BlockedStreamUtils.serializeToStream(fury, outputStream, buf -> fury.serialize((MemoryBuffer)buf, obj, null));
    }

    public static void serialize(Fury fury, OutputStream outputStream, Object obj, BufferCallback callback) {
        BlockedStreamUtils.serializeToStream(fury, outputStream, buf -> fury.serialize((MemoryBuffer)buf, obj, callback));
    }

    public static void serializeJavaObject(Fury fury, OutputStream outputStream, Object obj) {
        BlockedStreamUtils.serializeToStream(fury, outputStream, buf -> fury.serializeJavaObject((MemoryBuffer)buf, obj));
    }

    public static Object deserialize(Fury fury, InputStream inputStream) {
        return BlockedStreamUtils.deserialize(fury, inputStream, null);
    }

    public static Object deserialize(Fury fury, InputStream inputStream, Iterable<MemoryBuffer> outOfBandBuffers) {
        return BlockedStreamUtils.deserializeFromStream(fury, inputStream, buf -> fury.deserialize((MemoryBuffer)buf, outOfBandBuffers));
    }

    public static Object deserialize(Fury fury, ReadableByteChannel channel) {
        return BlockedStreamUtils.readFromChannel(fury, channel, b -> fury.deserialize((MemoryBuffer)b, null));
    }

    public static Object deserialize(Fury fury, ReadableByteChannel channel, Iterable<MemoryBuffer> outOfBandBuffers) {
        return BlockedStreamUtils.readFromChannel(fury, channel, b -> fury.deserialize((MemoryBuffer)b, outOfBandBuffers));
    }

    public static <T> T deserializeJavaObject(Fury fury, InputStream inputStream, Class<T> type) {
        return (T)BlockedStreamUtils.deserializeFromStream(fury, inputStream, buf -> fury.deserializeJavaObject((MemoryBuffer)buf, type));
    }

    public static Object deserializeJavaObject(Fury fury, ReadableByteChannel channel, Class<?> type) {
        return BlockedStreamUtils.readFromChannel(fury, channel, b -> fury.deserializeJavaObject((MemoryBuffer)b, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readFromChannel(Fury fury, ReadableByteChannel channel, Function<MemoryBuffer, Object> action) {
        try {
            MemoryBuffer buf = fury.getBuffer();
            buf.readerIndex(0);
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            BlockedStreamUtils.readByteBuffer(channel, byteBuffer, 4);
            int size = byteBuffer.getInt();
            buf.ensure(size);
            BlockedStreamUtils.readByteBuffer(channel, buf.sliceAsByteBuffer(), size);
            Object object = action.apply(buf);
            return object;
        }
        finally {
            fury.resetBuffer();
        }
    }

    private static void readByteBuffer(ReadableByteChannel channel, ByteBuffer buffer, int size) {
        buffer.limit(buffer.position() + size);
        try {
            for (int read = channel.read(buffer); read < size; read += channel.read(buffer)) {
                int len = channel.read(buffer);
                if (len != -1) continue;
                throw new DeserializationException(String.format("Channel only have %s, but need %s", read, size));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        buffer.rewind();
    }

    private static void serializeToStream(Fury fury, OutputStream outputStream, Consumer<MemoryBuffer> function) {
        MemoryBuffer buf = fury.getBuffer();
        buf.writerIndex(0);
        try {
            buf.writeInt32(-1);
            function.accept(buf);
            buf.putInt32(0, buf.writerIndex() - 4);
            byte[] bytes = buf.getHeapMemory();
            if (bytes != null) {
                outputStream.write(bytes, 0, buf.writerIndex());
            } else {
                outputStream.write(buf.getBytes(0, buf.writerIndex()));
            }
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            fury.resetBuffer();
        }
    }

    private static Object deserializeFromStream(Fury fury, InputStream inputStream, Function<MemoryBuffer, Object> function) {
        MemoryBuffer buf = fury.getBuffer();
        try {
            BlockedStreamUtils.readToBufferFromStream(inputStream, buf);
            Object object = function.apply(buf);
            return object;
        }
        catch (Throwable t) {
            throw ExceptionUtils.handleReadFailed(fury, t);
        }
        finally {
            fury.resetBuffer();
        }
    }

    private static void readToBufferFromStream(InputStream inputStream, MemoryBuffer buffer) throws IOException {
        buffer.readerIndex(0);
        int read = BlockedStreamUtils.readBytes(inputStream, buffer.getHeapMemory(), 0, 4);
        Preconditions.checkArgument(read == 4);
        int size = buffer.readInt32();
        buffer.ensure(4 + size);
        read = BlockedStreamUtils.readBytes(inputStream, buffer.getHeapMemory(), 4, size);
        Preconditions.checkArgument(read == size);
    }

    private static int readBytes(InputStream inputStream, byte[] buffer, int offset, int size) throws IOException {
        int read;
        int count = 0;
        for (read = 0; read < size && (count = inputStream.read(buffer, offset + read, size - read)) != -1; read += count) {
        }
        return read == 0 && count == -1 ? -1 : read;
    }
}

