/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import org.apache.fury.Fury;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.serializer.CompatibleSerializer;
import org.apache.fury.serializer.ImmutableSerializer;
import org.apache.fury.serializer.ObjectSerializer;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.StringSerializer;
import org.apache.fury.type.Type;
import org.apache.fury.util.ExceptionUtils;
import org.apache.fury.util.GraalvmSupport;
import org.apache.fury.util.StringUtils;
import org.apache.fury.util.function.Functions;
import org.apache.fury.util.unsafe._JDKAccess;

public class Serializers {
    private static final Cache<Class, Tuple2<MethodType, MethodHandle>> CTR_MAP;
    private static final MethodType SIG1;
    private static final MethodType SIG2;
    private static final MethodType SIG3;
    private static final MethodType SIG4;
    private static final ToIntFunction GET_CODER;
    private static final Function GET_VALUE;

    public static <T> Serializer<T> newSerializer(Fury fury, Class type, Class<? extends Serializer> serializerClass) {
        Serializer serializer = fury.getClassResolver().getSerializer(type, false);
        try {
            if (serializerClass == ObjectSerializer.class) {
                return new ObjectSerializer(fury, type);
            }
            if (serializerClass == CompatibleSerializer.class) {
                return new CompatibleSerializer(fury, type);
            }
            Tuple2 ctrInfo = (Tuple2)CTR_MAP.getIfPresent(serializerClass);
            if (ctrInfo != null) {
                MethodType sig = (MethodType)ctrInfo.f0;
                MethodHandle handle = (MethodHandle)ctrInfo.f1;
                if (sig.equals((Object)SIG1)) {
                    return handle.invoke(fury, type);
                }
                if (sig.equals((Object)SIG2)) {
                    return handle.invoke(fury);
                }
                if (sig.equals((Object)SIG3)) {
                    return handle.invoke(type);
                }
                return handle.invoke();
            }
            return Serializers.createSerializer(fury, type, serializerClass);
        }
        catch (InvocationTargetException e) {
            fury.getClassResolver().resetSerializer(type, serializer);
            if (e.getCause() != null) {
                Platform.throwException(e.getCause());
            } else {
                Platform.throwException(e);
            }
        }
        catch (Throwable t) {
            fury.getClassResolver().resetSerializer(type, serializer);
            Platform.throwException(t);
        }
        throw new IllegalStateException("unreachable");
    }

    private static <T> Serializer<T> createSerializer(Fury fury, Class<?> type, Class<? extends Serializer> serializerClass) throws Throwable {
        MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(serializerClass);
        try {
            MethodHandle ctr = lookup.findConstructor(serializerClass, SIG1);
            CTR_MAP.put(serializerClass, Tuple2.of(SIG1, ctr));
            return ctr.invoke(fury, type);
        }
        catch (NoSuchMethodException e) {
            ExceptionUtils.ignore(e);
            try {
                MethodHandle ctr = lookup.findConstructor(serializerClass, SIG2);
                CTR_MAP.put(serializerClass, Tuple2.of(SIG2, ctr));
                return ctr.invoke(fury);
            }
            catch (NoSuchMethodException e2) {
                ExceptionUtils.ignore(e2);
                try {
                    MethodHandle ctr = lookup.findConstructor(serializerClass, SIG3);
                    CTR_MAP.put(serializerClass, Tuple2.of(SIG3, ctr));
                    return ctr.invoke(type);
                }
                catch (NoSuchMethodException e3) {
                    MethodHandle ctr = ReflectionUtils.getCtrHandle(serializerClass, new Class[0]);
                    CTR_MAP.put(serializerClass, Tuple2.of(SIG4, ctr));
                    return ctr.invoke();
                }
            }
        }
    }

    public static Object readPrimitiveValue(Fury fury, MemoryBuffer buffer, short classId) {
        switch (classId) {
            case 5: {
                return buffer.readBoolean();
            }
            case 6: {
                return buffer.readByte();
            }
            case 7: {
                return Character.valueOf(buffer.readChar());
            }
            case 8: {
                return buffer.readInt16();
            }
            case 9: {
                if (fury.compressInt()) {
                    return buffer.readVarInt32();
                }
                return buffer.readInt32();
            }
            case 10: {
                return Float.valueOf(buffer.readFloat32());
            }
            case 11: {
                return fury.readInt64(buffer);
            }
            case 12: {
                return buffer.readFloat64();
            }
        }
        throw new IllegalStateException("unreachable");
    }

    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(Class.class, new ClassSerializer(fury));
        fury.registerSerializer(StringBuilder.class, new StringBuilderSerializer(fury));
        fury.registerSerializer(StringBuffer.class, new StringBufferSerializer(fury));
        fury.registerSerializer(BigInteger.class, new BigIntegerSerializer(fury));
        fury.registerSerializer(BigDecimal.class, new BigDecimalSerializer(fury));
        fury.registerSerializer(AtomicBoolean.class, new AtomicBooleanSerializer(fury));
        fury.registerSerializer(AtomicInteger.class, new AtomicIntegerSerializer(fury));
        fury.registerSerializer(AtomicLong.class, new AtomicLongSerializer(fury));
        fury.registerSerializer(AtomicReference.class, new AtomicReferenceSerializer(fury));
        fury.registerSerializer(Currency.class, new CurrencySerializer(fury));
        fury.registerSerializer(URI.class, new URISerializer(fury));
        fury.registerSerializer(Pattern.class, new RegexSerializer(fury));
        fury.registerSerializer(UUID.class, new UUIDSerializer(fury));
        fury.registerSerializer(Object.class, new EmptyObjectSerializer(fury));
    }

    static {
        ToIntFunction getCoder;
        CTR_MAP = GraalvmSupport.isGraalBuildtime() ? CacheBuilder.newBuilder().concurrencyLevel(32).build() : CacheBuilder.newBuilder().weakKeys().softValues().build();
        SIG1 = MethodType.methodType(Void.TYPE, Fury.class, Class.class);
        SIG2 = MethodType.methodType(Void.TYPE, Fury.class);
        SIG3 = MethodType.methodType(Void.TYPE, Class.class);
        SIG4 = MethodType.methodType(Void.TYPE);
        GET_VALUE = (Function)Functions.makeGetterFunction(StringBuilder.class.getSuperclass(), "getValue");
        try {
            Method getCoderMethod = StringBuilder.class.getSuperclass().getDeclaredMethod("getCoder", new Class[0]);
            getCoder = (ToIntFunction)Functions.makeGetterFunction(getCoderMethod, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            getCoder = null;
        }
        GET_CODER = getCoder;
    }

    public static final class EmptyObjectSerializer
    extends ImmutableSerializer<Object> {
        public EmptyObjectSerializer(Fury fury) {
            super(fury, Object.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Object value) {
        }

        @Override
        public Object read(MemoryBuffer buffer) {
            return new Object();
        }
    }

    public static final class ClassSerializer
    extends ImmutableSerializer<Class> {
        public ClassSerializer(Fury fury) {
            super(fury, Class.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Class value) {
            this.fury.getClassResolver().writeClassInternal(buffer, value);
        }

        @Override
        public Class read(MemoryBuffer buffer) {
            return this.fury.getClassResolver().readClassInternal(buffer);
        }
    }

    public static final class UUIDSerializer
    extends ImmutableSerializer<UUID> {
        public UUIDSerializer(Fury fury) {
            super(fury, UUID.class);
        }

        @Override
        public void write(MemoryBuffer buffer, UUID uuid) {
            buffer.writeInt64(uuid.getMostSignificantBits());
            buffer.writeInt64(uuid.getLeastSignificantBits());
        }

        @Override
        public UUID read(MemoryBuffer buffer) {
            return new UUID(buffer.readInt64(), buffer.readInt64());
        }
    }

    public static final class RegexSerializer
    extends ImmutableSerializer<Pattern> {
        public RegexSerializer(Fury fury) {
            super(fury, Pattern.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Pattern pattern) {
            this.fury.writeJavaString(buffer, pattern.pattern());
            buffer.writeInt32(pattern.flags());
        }

        @Override
        public Pattern read(MemoryBuffer buffer) {
            String regex = this.fury.readJavaString(buffer);
            int flags = buffer.readInt32();
            return Pattern.compile(regex, flags);
        }
    }

    public static final class URISerializer
    extends ImmutableSerializer<URI> {
        public URISerializer(Fury fury) {
            super(fury, URI.class);
        }

        @Override
        public void write(MemoryBuffer buffer, URI uri) {
            this.fury.writeString(buffer, uri.toString());
        }

        @Override
        public URI read(MemoryBuffer buffer) {
            return URI.create(this.fury.readString(buffer));
        }
    }

    public static final class CharsetSerializer<T extends Charset>
    extends ImmutableSerializer<T> {
        public CharsetSerializer(Fury fury, Class<T> type) {
            super(fury, type);
        }

        @Override
        public void write(MemoryBuffer buffer, T object) {
            this.fury.writeJavaString(buffer, ((Charset)object).name());
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)Charset.forName(this.fury.readJavaString(buffer));
        }
    }

    public static final class CurrencySerializer
    extends ImmutableSerializer<Currency> {
        public CurrencySerializer(Fury fury) {
            super(fury, Currency.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Currency object) {
            this.fury.writeJavaString(buffer, object.getCurrencyCode());
        }

        @Override
        public Currency read(MemoryBuffer buffer) {
            String currencyCode = this.fury.readJavaString(buffer);
            return Currency.getInstance(currencyCode);
        }
    }

    public static final class AtomicReferenceSerializer
    extends Serializer<AtomicReference> {
        public AtomicReferenceSerializer(Fury fury) {
            super(fury, AtomicReference.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicReference value) {
            this.fury.writeRef(buffer, value.get());
        }

        @Override
        public AtomicReference copy(AtomicReference origin) {
            return new AtomicReference(this.fury.copyObject(origin.get()));
        }

        @Override
        public AtomicReference read(MemoryBuffer buffer) {
            return new AtomicReference<Object>(this.fury.readRef(buffer));
        }
    }

    public static final class AtomicLongSerializer
    extends Serializer<AtomicLong> {
        public AtomicLongSerializer(Fury fury) {
            super(fury, AtomicLong.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicLong value) {
            buffer.writeInt64(value.get());
        }

        @Override
        public AtomicLong copy(AtomicLong origin) {
            return new AtomicLong(origin.get());
        }

        @Override
        public AtomicLong read(MemoryBuffer buffer) {
            return new AtomicLong(buffer.readInt64());
        }
    }

    public static final class AtomicIntegerSerializer
    extends Serializer<AtomicInteger> {
        public AtomicIntegerSerializer(Fury fury) {
            super(fury, AtomicInteger.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicInteger value) {
            buffer.writeInt32(value.get());
        }

        @Override
        public AtomicInteger copy(AtomicInteger origin) {
            return new AtomicInteger(origin.get());
        }

        @Override
        public AtomicInteger read(MemoryBuffer buffer) {
            return new AtomicInteger(buffer.readInt32());
        }
    }

    public static final class AtomicBooleanSerializer
    extends Serializer<AtomicBoolean> {
        public AtomicBooleanSerializer(Fury fury) {
            super(fury, AtomicBoolean.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicBoolean value) {
            buffer.writeBoolean(value.get());
        }

        @Override
        public AtomicBoolean copy(AtomicBoolean origin) {
            return new AtomicBoolean(origin.get());
        }

        @Override
        public AtomicBoolean read(MemoryBuffer buffer) {
            return new AtomicBoolean(buffer.readBoolean());
        }
    }

    public static final class BigIntegerSerializer
    extends ImmutableSerializer<BigInteger> {
        public BigIntegerSerializer(Fury fury) {
            super(fury, BigInteger.class);
        }

        @Override
        public void write(MemoryBuffer buffer, BigInteger value) {
            byte[] bytes = value.toByteArray();
            buffer.writeVarUint32Small7(bytes.length);
            buffer.writeBytes(bytes);
        }

        @Override
        public BigInteger read(MemoryBuffer buffer) {
            int len = buffer.readVarUint32Small7();
            byte[] bytes = buffer.readBytes(len);
            return new BigInteger(bytes);
        }
    }

    public static final class BigDecimalSerializer
    extends ImmutableSerializer<BigDecimal> {
        public BigDecimalSerializer(Fury fury) {
            super(fury, BigDecimal.class);
        }

        @Override
        public void write(MemoryBuffer buffer, BigDecimal value) {
            byte[] bytes = value.unscaledValue().toByteArray();
            buffer.writeVarUint32Small7(value.scale());
            buffer.writeVarUint32Small7(value.precision());
            buffer.writeVarUint32Small7(bytes.length);
            buffer.writeBytes(bytes);
        }

        @Override
        public BigDecimal read(MemoryBuffer buffer) {
            int scale = buffer.readVarUint32Small7();
            int precision = buffer.readVarUint32Small7();
            int len = buffer.readVarUint32Small7();
            byte[] bytes = buffer.readBytes(len);
            BigInteger bigInteger = new BigInteger(bytes);
            return new BigDecimal(bigInteger, scale, new MathContext(precision));
        }
    }

    public static final class StringBufferSerializer
    extends AbstractStringBuilderSerializer<StringBuffer> {
        public StringBufferSerializer(Fury fury) {
            super(fury, StringBuffer.class);
        }

        @Override
        public StringBuffer copy(StringBuffer origin) {
            return new StringBuffer(origin);
        }

        @Override
        public StringBuffer read(MemoryBuffer buffer) {
            return new StringBuffer(this.stringSerializer.readJavaString(buffer));
        }

        @Override
        public StringBuffer xread(MemoryBuffer buffer) {
            return new StringBuffer(this.stringSerializer.readUTF8String(buffer));
        }
    }

    public static final class StringBuilderSerializer
    extends AbstractStringBuilderSerializer<StringBuilder> {
        public StringBuilderSerializer(Fury fury) {
            super(fury, StringBuilder.class);
        }

        @Override
        public StringBuilder copy(StringBuilder origin) {
            return new StringBuilder(origin);
        }

        @Override
        public StringBuilder read(MemoryBuffer buffer) {
            return new StringBuilder(this.stringSerializer.readJavaString(buffer));
        }

        @Override
        public StringBuilder xread(MemoryBuffer buffer) {
            return new StringBuilder(this.stringSerializer.readUTF8String(buffer));
        }
    }

    public static abstract class AbstractStringBuilderSerializer<T extends CharSequence>
    extends Serializer<T> {
        protected final StringSerializer stringSerializer;

        public AbstractStringBuilderSerializer(Fury fury, Class<T> type) {
            super(fury, type);
            this.stringSerializer = new StringSerializer(fury);
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            this.stringSerializer.writeUTF8String(buffer, value.toString());
        }

        @Override
        public short getXtypeId() {
            return -Type.STRING.getId();
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            if (GET_CODER != null) {
                int coder = GET_CODER.applyAsInt(value);
                byte[] v = (byte[])GET_VALUE.apply(value);
                int bytesLen = value.length();
                if (coder != 0) {
                    if (coder != 1) {
                        throw new UnsupportedOperationException("Unsupported coder " + coder);
                    }
                    bytesLen <<= 1;
                }
                long header = (long)bytesLen << 2 | (long)coder;
                buffer.writeVarUint64(header);
                buffer.writeBytes(v, 0, bytesLen);
            } else {
                char[] v = (char[])GET_VALUE.apply(value);
                if (StringUtils.isLatin(v)) {
                    this.stringSerializer.writeCharsLatin1(buffer, v, value.length());
                } else {
                    this.stringSerializer.writeCharsUTF16(buffer, v, value.length());
                }
            }
        }
    }

    public static abstract class CrossLanguageCompatibleSerializer<T>
    extends Serializer<T> {
        private final short typeId;

        public CrossLanguageCompatibleSerializer(Fury fury, Class<T> cls, short typeId) {
            super(fury, cls);
            this.typeId = typeId;
        }

        public CrossLanguageCompatibleSerializer(Fury fury, Class<T> cls, short typeId, boolean needToWriteRef) {
            super(fury, cls, needToWriteRef);
            this.typeId = typeId;
        }

        public CrossLanguageCompatibleSerializer(Fury fury, Class<T> cls, short typeId, boolean needToWriteRef, boolean immutable) {
            super(fury, cls, needToWriteRef, immutable);
            this.typeId = typeId;
        }

        @Override
        public short getXtypeId() {
            return this.typeId;
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            this.write(buffer, value);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            return this.read(buffer);
        }
    }
}

