/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.util;

import org.apache.fury.memory.Platform;
import org.apache.fury.util.StringUtils;

public class StringEncodingUtils {
    public static int convertUTF16ToUTF8(char[] src, byte[] dst, int dp) {
        int numChars = src.length;
        int charOffset = 0;
        int arrayOffset = Platform.CHAR_ARRAY_OFFSET;
        while (charOffset < numChars) {
            if (charOffset + 4 <= numChars && (Platform.getLong(src, arrayOffset) & StringUtils.MULTI_CHARS_NON_ASCII_MASK) == 0L) {
                dst[dp] = (byte)src[charOffset];
                dst[dp + 1] = (byte)src[charOffset + 1];
                dst[dp + 2] = (byte)src[charOffset + 2];
                dst[dp + 3] = (byte)src[charOffset + 3];
                dp += 4;
                charOffset += 4;
                arrayOffset += 8;
                continue;
            }
            char c = src[charOffset++];
            arrayOffset += 2;
            if (c < '\u0080') {
                dst[dp++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                dst[dp] = (byte)(0xC0 | c >> 6);
                dst[dp + 1] = (byte)(0x80 | c & 0x3F);
                dp += 2;
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                StringEncodingUtils.utf8ToChar2(src, charOffset, c, dst, dp);
                dp += 4;
                ++charOffset;
                arrayOffset += 2;
                continue;
            }
            dst[dp] = (byte)(0xE0 | c >> 12);
            dst[dp + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp + 2] = (byte)(0x80 | c & 0x3F);
            dp += 3;
        }
        return dp;
    }

    public static int convertUTF16ToUTF8(byte[] src, byte[] dst, int dp) {
        int numBytes = src.length;
        int offset = 0;
        while (offset < numBytes) {
            if (offset + 8 <= numBytes && (Platform.getLong(src, Platform.BYTE_ARRAY_OFFSET + offset) & StringUtils.MULTI_CHARS_NON_ASCII_MASK) == 0L) {
                if (Platform.IS_LITTLE_ENDIAN) {
                    dst[dp] = src[offset];
                    dst[dp + 1] = src[offset + 2];
                    dst[dp + 2] = src[offset + 4];
                    dst[dp + 3] = src[offset + 6];
                } else {
                    dst[dp] = src[offset + 1];
                    dst[dp + 1] = src[offset + 3];
                    dst[dp + 2] = src[offset + 5];
                    dst[dp + 3] = src[offset + 7];
                }
                dp += 4;
                offset += 8;
                continue;
            }
            char c = Platform.getChar(src, Platform.BYTE_ARRAY_OFFSET + offset);
            offset += 2;
            if (c < '\u0080') {
                dst[dp++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                dst[dp] = (byte)(0xC0 | c >> 6);
                dst[dp + 1] = (byte)(0x80 | c & 0x3F);
                dp += 2;
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                StringEncodingUtils.utf8ToChar2(src, offset, c, numBytes, dst, dp);
                dp += 4;
                offset += 2;
                continue;
            }
            dst[dp] = (byte)(0xE0 | c >> 12);
            dst[dp + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp + 2] = (byte)(0x80 | c & 0x3F);
            dp += 3;
        }
        return dp;
    }

    public static int convertUTF8ToUTF16(byte[] src, int offset, int len, byte[] dst) {
        int end = offset + len;
        int dp = 0;
        while (offset < end) {
            byte b1;
            byte b0;
            if (offset + 8 <= end && (Platform.getLong(src, Platform.BYTE_ARRAY_OFFSET + offset) & 0x8080808080808080L) == 0L) {
                if (Platform.IS_LITTLE_ENDIAN) {
                    dst[dp] = src[offset];
                    dst[dp + 2] = src[offset + 1];
                    dst[dp + 4] = src[offset + 2];
                    dst[dp + 6] = src[offset + 3];
                    dst[dp + 8] = src[offset + 4];
                    dst[dp + 10] = src[offset + 5];
                    dst[dp + 12] = src[offset + 6];
                    dst[dp + 14] = src[offset + 7];
                } else {
                    dst[dp + 1] = src[offset];
                    dst[dp + 3] = src[offset + 1];
                    dst[dp + 5] = src[offset + 2];
                    dst[dp + 7] = src[offset + 3];
                    dst[dp + 9] = src[offset + 4];
                    dst[dp + 11] = src[offset + 5];
                    dst[dp + 13] = src[offset + 6];
                    dst[dp + 15] = src[offset + 7];
                }
                dp += 16;
                offset += 8;
                continue;
            }
            if ((b0 = src[offset++]) >= 0) {
                dst[dp] = b0;
                dst[dp + 1] = 0;
                dp += 2;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                if (offset >= end) {
                    return -1;
                }
                if (((b1 = src[offset++]) & 0xC0) != 128) {
                    return -1;
                }
                char c = (char)(b0 << 6 ^ b1 ^ 0xF80);
                dst[dp] = (byte)c;
                dst[dp + 1] = (byte)(c >> 8);
                dp += 2;
                continue;
            }
            if (b0 >> 4 == -2) {
                boolean isSurrogate;
                if (offset + 1 >= end) {
                    return -1;
                }
                b1 = src[offset];
                byte b2 = src[offset + 1];
                offset += 2;
                if (b0 == -32 && (b1 & 0xE0) == 128 || (b1 & 0xC0) != 128 || (b2 & 0xC0) != 128) {
                    return -1;
                }
                char c = (char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80));
                boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                if (isSurrogate) {
                    return -1;
                }
                dst[dp] = (byte)c;
                dst[dp + 1] = (byte)(c >> 8);
                dp += 2;
                continue;
            }
            if (b0 >> 3 == -2) {
                if (offset + 2 >= end) {
                    return -1;
                }
                byte b2 = src[offset];
                byte b3 = src[offset + 1];
                byte b4 = src[offset + 2];
                offset += 3;
                int uc = b0 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                    return -1;
                }
                char c = (char)((uc >>> 10) + 55232);
                dst[dp] = (byte)c;
                dst[dp + 1] = (byte)(c >> 8);
                c = (char)((uc & 0x3FF) + 56320);
                dst[dp += 2] = (byte)c;
                dst[dp + 1] = (byte)(c >> 8);
                dp += 2;
                continue;
            }
            return -1;
        }
        return dp;
    }

    public static int convertUTF8ToUTF16(byte[] src, int offset, int len, char[] dst) {
        int end = offset + len;
        int dp = 0;
        while (offset < end) {
            byte b3;
            byte b2;
            byte b1;
            if (offset + 8 <= end && (Platform.getLong(src, Platform.BYTE_ARRAY_OFFSET + offset) & 0x8080808080808080L) == 0L) {
                dst[dp] = (char)src[offset];
                dst[dp + 1] = (char)src[offset + 1];
                dst[dp + 2] = (char)src[offset + 2];
                dst[dp + 3] = (char)src[offset + 3];
                dst[dp + 4] = (char)src[offset + 4];
                dst[dp + 5] = (char)src[offset + 5];
                dst[dp + 6] = (char)src[offset + 6];
                dst[dp + 7] = (char)src[offset + 7];
                dp += 8;
                offset += 8;
                continue;
            }
            if ((b1 = src[offset++]) >= 0) {
                dst[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (offset >= end) {
                    return -1;
                }
                if (((b2 = src[offset++]) & 0xC0) != 128) {
                    return -1;
                }
                dst[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                continue;
            }
            if (b1 >> 4 == -2) {
                boolean isSurrogate;
                if (offset + 1 >= end) {
                    return -1;
                }
                b2 = src[offset];
                b3 = src[offset + 1];
                offset += 2;
                if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                    return -1;
                }
                char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                if (isSurrogate) {
                    return -1;
                }
                dst[dp++] = c;
                continue;
            }
            if (b1 >> 3 == -2) {
                if (offset + 2 >= end) {
                    return -1;
                }
                b2 = src[offset];
                b3 = src[offset + 1];
                byte b4 = src[offset + 2];
                offset += 3;
                int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                    return -1;
                }
                dst[dp] = (char)((uc >>> 10) + 55232);
                dst[dp + 1] = (char)((uc & 0x3FF) + 56320);
                dp += 2;
                continue;
            }
            return -1;
        }
        return dp;
    }

    private static void utf8ToChar2(char[] src, int charOffset, char c, byte[] dst, int dp) {
        char d;
        if (c > '\udbff' || charOffset == src.length || (d = src[charOffset]) < '\udc00' || d > '\udfff') {
            throw new RuntimeException("malformed input off : " + charOffset);
        }
        int uc = (c << 10) + d + -56613888;
        dst[dp] = (byte)(0xF0 | uc >> 18);
        dst[dp + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
        dst[dp + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
        dst[dp + 3] = (byte)(0x80 | uc & 0x3F);
    }

    private static void utf8ToChar2(byte[] src, int offset, char c, int numBytes, byte[] dst, int dp) {
        char d;
        if (c > '\udbff' || numBytes - offset < 1 || (d = Platform.getChar(src, Platform.BYTE_ARRAY_OFFSET + offset)) < '\udc00' || d > '\udfff') {
            throw new RuntimeException("malformed input off : " + offset);
        }
        int uc = (c << 10) + d + -56613888;
        dst[dp] = (byte)(0xF0 | uc >> 18);
        dst[dp + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
        dst[dp + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
        dst[dp + 3] = (byte)(0x80 | uc & 0x3F);
    }
}

