/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.curator.utils;

import org.apache.hadoop.hbase.shaded.org.apache.curator.utils.InjectSessionExpiration;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooKeeper;
import org.slf4j.LoggerFactory;

public class Compatibility {
    private static final boolean hasZooKeeperAdmin;

    public static boolean isZK34() {
        return !hasZooKeeperAdmin;
    }

    public static void injectSessionExpiration(ZooKeeper zooKeeper) {
        if (Compatibility.isZK34()) {
            InjectSessionExpiration.injectSessionExpiration(zooKeeper);
        } else {
            zooKeeper.getTestable().injectSessionExpiration();
        }
    }

    static {
        boolean hasIt;
        try {
            Class.forName("org.apache.hadoop.hbase.shaded.org.apache.zookeeper.admin.ZooKeeperAdmin");
            hasIt = true;
        }
        catch (ClassNotFoundException e) {
            hasIt = false;
            LoggerFactory.getLogger(Compatibility.class).info("Running in ZooKeeper 3.4.x compatibility mode");
        }
        hasZooKeeperAdmin = hasIt;
    }
}

