/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import org.apache.commons.lang3.StringUtils;

public enum HugeDefaultRole {
    SPACE("space"),
    SPACE_MEMBER("space_member"),
    ANALYST("analyst"),
    OBSERVER("observer");

    public static final String DEFAULT_SPACE_TARGET_KEY = "DEFAULT_SPACE_TARGET";
    private final String name;

    private HugeDefaultRole(String name) {
        this.name = name;
    }

    public static boolean isObserver(String role) {
        return role.endsWith(HugeDefaultRole.OBSERVER.name) && HugeDefaultRole.OBSERVER.name.length() != role.length();
    }

    public static String getNickname(String role) {
        if (HugeDefaultRole.isObserver(role)) {
            String graph = role.substring(0, role.lastIndexOf("_"));
            return graph + "-\u89c2\u5bdf\u8005";
        }
        if (HugeDefaultRole.SPACE.name.equals(role)) {
            return "\u56fe\u7a7a\u95f4\u7ba1\u7406\u5458";
        }
        if (HugeDefaultRole.SPACE_MEMBER.name.equals(role)) {
            return "\u56fe\u7a7a\u95f4\u6210\u5458";
        }
        if (HugeDefaultRole.ANALYST.name.equals(role)) {
            return "\u5206\u6790\u5e08";
        }
        return role;
    }

    public static boolean isDefaultNickname(String nickname) {
        return StringUtils.isNotEmpty((CharSequence)nickname) && ("\u56fe\u7a7a\u95f4\u7ba1\u7406\u5458".equals(nickname) || "\u56fe\u7a7a\u95f4\u6210\u5458".equals(nickname) || "\u5206\u6790\u5e08".equals(nickname) || nickname.endsWith("-\u89c2\u5bdf\u8005"));
    }

    public static boolean isDefault(String role) {
        return HugeDefaultRole.isObserver(role) || HugeDefaultRole.SPACE.name.equals(role) || HugeDefaultRole.SPACE_MEMBER.name.equals(role) || HugeDefaultRole.ANALYST.name.equals(role);
    }

    public static boolean isDefaultTarget(String target) {
        return target.endsWith(DEFAULT_SPACE_TARGET_KEY);
    }

    public String toString() {
        return this.name;
    }

    public boolean isGraphRole() {
        return this.ordinal() >= OBSERVER.ordinal();
    }
}

