/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft.rpc;

import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequestProcessor;
import com.google.protobuf.Message;
import org.apache.hugegraph.backend.store.raft.RaftContext;
import org.apache.hugegraph.backend.store.raft.RaftGroupManager;
import org.apache.hugegraph.backend.store.raft.rpc.RaftRequests;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class SetLeaderProcessor
extends RpcRequestProcessor<RaftRequests.SetLeaderRequest> {
    private static final Logger LOG = Log.logger(SetLeaderProcessor.class);
    private final RaftContext context;

    public SetLeaderProcessor(RaftContext context) {
        super(null, null);
        this.context = context;
    }

    public Message processRequest(RaftRequests.SetLeaderRequest request, RpcRequestClosure done) {
        LOG.debug("Processing SetLeaderRequest {}", request.getClass());
        RaftGroupManager nodeManager = this.context.raftNodeManager();
        try {
            nodeManager.setLeader(request.getEndpoint());
            RaftRequests.CommonResponse common = RaftRequests.CommonResponse.newBuilder().setStatus(true).build();
            return RaftRequests.SetLeaderResponse.newBuilder().setCommon(common).build();
        }
        catch (Throwable e) {
            RaftRequests.CommonResponse common = RaftRequests.CommonResponse.newBuilder().setStatus(false).setMessage(e.toString()).build();
            return RaftRequests.SetLeaderResponse.newBuilder().setCommon(common).build();
        }
    }

    public String interest() {
        return RaftRequests.SetLeaderRequest.class.getName();
    }
}

