/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.schema;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.tx.ISchemaTransaction;
import org.apache.hugegraph.job.SysJob;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class SchemaJob
extends SysJob<Object> {
    public static final String REMOVE_SCHEMA = "remove_schema";
    public static final String REBUILD_INDEX = "rebuild_index";
    public static final String CREATE_INDEX = "create_index";
    public static final String CREATE_OLAP = "create_olap";
    public static final String CLEAR_OLAP = "clear_olap";
    public static final String REMOVE_OLAP = "remove_olap";
    protected static final Logger LOG = Log.logger(SchemaJob.class);
    private static final String SPLITOR = ":";

    protected HugeType schemaType() {
        String name = this.task().name();
        String[] parts = name.split(SPLITOR, 3);
        E.checkState((parts.length == 3 && parts[0] != null ? 1 : 0) != 0, (String)"Task name should be formatted to String 'TYPE:ID:NAME', but got '%s'", (Object[])new Object[]{name});
        return HugeType.valueOf(parts[0]);
    }

    protected Id schemaId() {
        String name = this.task().name();
        String[] parts = name.split(SPLITOR, 3);
        E.checkState((parts.length == 3 && parts[1] != null ? 1 : 0) != 0, (String)"Task name should be formatted to String 'TYPE:ID:NAME', but got '%s'", (Object[])new Object[]{name});
        return IdGenerator.of(Long.valueOf(parts[1]));
    }

    protected String schemaName() {
        String name = this.task().name();
        String[] parts = name.split(SPLITOR, 3);
        E.checkState((parts.length == 3 && parts[2] != null ? 1 : 0) != 0, (String)"Task name should be formatted to String 'TYPE:ID:NAME', but got '%s'", (Object[])new Object[]{name});
        return parts[2];
    }

    public static String formatTaskName(HugeType type, Id id, String name) {
        E.checkNotNull((Object)type, (String)"schema type");
        E.checkNotNull((Object)id, (String)"schema id");
        E.checkNotNull((Object)name, (String)"schema name");
        return String.join((CharSequence)SPLITOR, type.toString(), id.asString(), name);
    }

    protected static void removeSchema(ISchemaTransaction tx, SchemaElement schema) {
        try {
            Method method = ISchemaTransaction.class.getDeclaredMethod("removeSchema", SchemaElement.class);
            method.setAccessible(true);
            method.invoke((Object)tx, schema);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError("Can't call SchemaTransaction.removeSchema()", e);
        }
    }

    protected static void updateSchema(ISchemaTransaction tx, SchemaElement schema) {
        try {
            Method method = ISchemaTransaction.class.getDeclaredMethod("updateSchema", SchemaElement.class);
            method.setAccessible(true);
            method.invoke((Object)tx, schema);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError("Can't call SchemaTransaction.updateSchema()", e);
        }
    }
}

